/* 
 * File:   main.c
 * Author: takano satoshi
 *
 * Created on 2020/01/20, 15:50
 */
// PIC16F18325 Configuration Bit Settings

// 'C' source line config statements

// CONFIG1
#pragma config FEXTOSC = OFF    // FEXTOSC External Oscillator mode Selection bits (Oscillator not enabled)
#pragma config RSTOSC = HFINT32 // Power-up default value for COSC bits (HFINTOSC with 2x PLL (32MHz))
#pragma config CLKOUTEN = OFF   // Clock Out Enable bit (CLKOUT function is disabled; I/O or oscillator function on OSC2)
#pragma config CSWEN = ON       // Clock Switch Enable bit (Writing to NOSC and NDIV is allowed)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config MCLRE = OFF      // Master Clear Enable bit (MCLR/VPP pin function is digital input; MCLR internally disabled; Weak pull-up under control of port pin's WPU control bit.)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config WDTE = ON        // Watchdog Timer Enable bits (WDT enabled, SWDTEN is ignored)
#pragma config LPBOREN = OFF    // Low-power BOR enable bit (ULPBOR disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable bits (Brown-out Reset enabled, SBOREN bit ignored)
#pragma config BORV = LOW       // Brown-out Reset Voltage selection bit (Brown-out voltage (Vbor) set to 2.45V)
#pragma config PPS1WAY = ON     // PPSLOCK bit One-Way Set Enable bit (The PPSLOCK bit can be cleared and set only once; PPS registers remain locked after one clear/set cycle)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable bit (Stack Overflow or Underflow will cause a Reset)
#pragma config DEBUG = OFF      // Debugger enable bit (Background debugger disabled)

// CONFIG3
#pragma config WRT = OFF        // User NVM self-write protection bits (Write protection off)
#pragma config LVP = OFF        // Low Voltage Programming Enable bit (High Voltage on MCLR/VPP must be used for programming.)

// CONFIG4
#pragma config CP = OFF         // User NVM Program Memory Code Protection bit (User NVM code protection disabled)
#pragma config CPD = OFF        // Data NVM Memory Code Protection bit (Data NVM code protection disabled)

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

#include <xc.h>
#include <stdio.h>
#include <stdlib.h>

#define _XTAL_FREQ  32000000

#define Blue_LED    RA2
#define For_SW      RC2
#define Rev_SW      RC3
#define ON          0
#define OFF         1

/*
 * 
 */
int main(int argc, char** argv) {
    OSCCON1 = 0x00;                                                 // Clock Source"HFINTOSCwith2xPLL(32MHz);Clock divider"1"
    ANSELA = 0b00000011;                                            // RA0,RA1AiO[hASẴsfW^[hɐݒ
    ANSELC = 0b00110000;                                            // RC4,RC5AiO[hASẴsfW^[hɐݒ   
    TRISA = 0b00001011;                                             // RA0,RA1,RA3́ASẴso͂ɐݒ
    TRISC = 0b00111111;                                             // SẴs͂ɐݒ
    WPUC  = 0b00000000;                                             // SẴsɃuAbvtȂ
  
        
        //PWM SET
        // MotorDriver̓͂RA4RA5ɂȂ܂̂ŁAPWM{[g̐ݒs܂B
        PPSLOCKbits.PPSLOCKED = 0;                                      // PPS not lockd
        RA4PPS = 0b00001100;                                            // CCP1RA4ɐݒ(CW)
        RA5PPS = 0b00001101;                                            // CCP2RA5ɐݒ(CCW)
        PPSLOCKbits.PPSLOCKED = 1;                                      // PPS Lockd
    
        // PWM̐ݒBBB
        //T2CONbits.T2CKPS = 0b00;                                      // Prescaler is 1 (32KHz)
        //T2CONbits.T2CKPS = 0b01;                                      // Prescaler is 4 (8KHz)        
        //T2CONbits.T2CKPS = 0b10;                                      // Prescaler is 16 (2KHz)
        T2CONbits.T2CKPS = 0b11;                                        // Prescaler is 64 (500Hz)
        
        PR2 = 249;                                                      // TIMER2 PERIOD REGISTER()
        
        //@̌vZ@@32MHz/4 * Prescaler1/64 * 1/PR2(249+1) = 500Hz(2ms)
    
        CCPR1H = 0;                                                     // CCP1 Register High Byte(Duty)
        CCPR1L = 0;                                                     // CCP1 Register Low Byte
        CCPR2H = 0;                                                     // CCP2 Register Hiht Byte(Duty)
        CCPR2L = 0;                                                     // CCP2 Register Low Byte
        
        // DutyvZ@CCPR1H / PR2 = 50 / (249+1) = 20%
    
        CCP1CON = 0b10011111;                                           // CCP1 Module Enable;Right aligned format;PWM mode
        CCP2CON = 0b10011111;                                           // CCP2 Module Enable;Riht alignend format;PWM mode
        
        T2CONbits.TMR2ON = 1;                                           // Timer2 is on  
    
      
    
    int ADC_VR2_in = 0;
    int i = 0;

    while(1){
        
        ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
        ADCON0 = 0b01010101;                                            // ANC5ADCϊɐݒ
    
        __delay_us(10);
        GO = 1;
        while( GO );                                                    // GOω҂
    
        ADC_VR2_in = ADRESH;                                            
        if(ADC_VR2_in >= 250){                                          
            ADC_VR2_in = 249;                                           
        }
        if(For_SW == 0){                                                
            CCPR1H =ADC_VR2_in;                                         
        }
        else if(Rev_SW == 0){                                           
            CCPR2H = ADC_VR2_in;                                        
        }
        else{                                                           
            CCPR1H = 0;                                                 
            CCPR2H = 0;
        }
        
        __delay_ms(100);                                                
        
    }
    
    return (EXIT_SUCCESS);
}

