// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                          P'sTec
//              LED_Control_Board Soft
//                                      2020/11/11
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                        Rev.0.0
//    Port Set
//      D0    RX                  AD0   Volume
//      D1    TX                  AD1   /PushSW1
//      D2    /LED_Blue           AD2   /PushSW2
//      D3    /LED_Orenge         AD3   /PushSW3
//      D4    LED_Out1            AD4   /PushSW4
//      D5    LED_Out2            AD5   Temp
//      D6    LED_Out3
//      D7    LED_Out4
//      D8    LCD_E
//      D9    LCD_RS
//      D10   LCD_D4
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7                                                  *印の数が各Stepで出てきたもの

#include <LiquidCrystal.h>                                            // ** LCDモジュールのインクルード

//                rs, enable, d4, d5, d6, d7
LiquidCrystal lcd( 9, 8     , 10, 11, 12, 13);                        //　** LCDポート設定

#define LED_Out1    4                                                 // ***** LED_Out1に定数    4
#define LED_Out2    5                                                 // ***** LED_Out2に定数    5
#define LED_Out3    6                                                 // ***** LED_Out3に定数    6
#define LED_Out4    7                                                 // ***** LED_Out4に定数    7

int Volume = 0;                                                       // ***　ボリューム　アナログ入力ピン #defineにした方が良いです
int Volume_val = 0;                                                   // *** ボリューム値の変数
char buff[16];                                                        // 変数 LCD表示文字
int LED_Blue = 2;                                                     // Blue LED    #defineにした方が良いです
int LED_Orenge = 3;                                                   // Orenge LED  #defineにした方が良いです
int PushSW1 = 1;                                                      // PWMフィードバック1　アナログ入力ピン
int PWM_val = 0;                                                      // **** PWM値の変数
int i = 0;                                                            // ***** 変数i

void setup() {
  // put your setup code here, to run once:
  
  pinMode(LED_Blue, OUTPUT);                                          // * LED_Blueのポート初期設定
  pinMode(LED_Orenge, OUTPUT);                                        // **** LED_Orengeのポート初期設定
  pinMode(LED_Out1, OUTPUT);                                          // ***** LED_Out1のポート初期設定
  pinMode(LED_Out2, OUTPUT);                                          // ***** LED_Out2のポート初期設定
  pinMode(LED_Out3, OUTPUT);                                          // ***** LED_Out3のポート初期設定
  pinMode(LED_Out4, OUTPUT);                                          // ***** LED_Out4のポート初期設定

  lcd.begin(16,2);                                                    // ** LCD表示範囲指定
  lcd.clear();                                                        // ** LCDクリアー

  lcd.setCursor(0,0);                                                 // ** LCDのカーソルを"0,0"の位置へ                                               
  lcd.print("Hello ArduinoUNO");                                      // ** LCDに表示

  delay(2000);                                                        // ディレイ2s
  lcd.clear();                                                        // ** LCDクリアー
}

void loop() {
  // put your main code here, to run repeatedly:

    Volume_val = analogRead(Volume);                                  // *** ボリュームポートからアナログ値を読み込み
    sprintf(buff, "%4d%",Volume_val);                                 // *** ボリューム値をLCD表示形式に
    lcd.setCursor(0,1);                                               // *** LCDのカーソルを"0,1"の位置へ
    lcd.print(buff);                                                  // *** ボリューム値をLCDに表示
    lcd.setCursor(8,0);                                               // ***** LCDのカーソルを"8,0"の位置へ
    lcd.print(i);                                                     // ***** カウンター値をLCDに表示
    
    if(analogRead(PushSW1) <= 512 && i <= 50){                        // * スイッチ読み込み(アナログポート)、値が半分以下なら。。。
      digitalWrite(LED_Blue,0);                                       // * ブルーLEDのポートを0(点灯)する
      digitalWrite(LED_Out1,1);                                       // ***** テープLED1のポートを1(点灯)する
      digitalWrite(LED_Out4,1);                                       // ***** テープLED4のポートを1(点灯)する

      lcd.setCursor(0,0);                                             // ** LCDのカーソルを"0,0"の位置へ
      lcd.print("ON ");                                               // ** LCDに"ON "を表示                                             
    }
    else{                                                             // * 上記ifが真でなければ。。。
      digitalWrite(LED_Blue,1);                                       // * ブルーLEDのポートを1(消灯)する
      digitalWrite(LED_Out1,0);                                       // ***** テープLED1のポートを0(消灯)する
      digitalWrite(LED_Out4,0);                                       // ***** テープLED4のポートを0(消灯)する

      lcd.setCursor(0,0);                                             // ** LCDのカーソルを"0,0"の位置へ
      lcd.print("OFF");                                               // ** LCDに"OFF"を表示
    }
    PWM_val = Volume_val / 4;                                         // **** ボリュームの入力値をPWMの出力値に変換
    analogWrite(LED_Orenge, 255-PWM_val);                             // **** オンボードオレンジLEDにPWM出力
    analogWrite(LED_Out2, PWM_val);                                   // ***** テープLED出力2にPWM出力
    analogWrite(LED_Out3, PWM_val);                                   // ***** テープLED出力3にPWM出力

    i = ++i;
    if(i >= 100){
      i = 0;
    }
    delay(10);                                                        // ディレイ10ms
}
