// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                          P'sTec
//              LED_Control_Board Soft
//                                      2020/11/11
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                        Rev.0.0
//    Port Set
//      D0    RX                  AD0   Volume
//      D1    TX                  AD1   /PushSW1
//      D2    /LED_Blue           AD2   /PushSW2
//      D3    /LED_Orenge         AD3   /PushSW3
//      D4    LED_Out1            AD4   /PushSW4
//      D5    LED_Out2            AD5   Temp
//      D6    LED_Out3
//      D7    LED_Out4
//      D8    LCD_E
//      D9    LCD_RS
//      D10   LCD_D4
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7

#include <LiquidCrystal.h>

//                rs, enable, d4, d5, d6, d7
LiquidCrystal lcd( 9, 8     , 10, 11, 12, 13);                        //　LCDポート設定

int Volume = 0;                                                       // ボリューム　アナログ入力ピン***
int Volume_val = 0;
char buff[16];                                                        // 変数 LCD表示文字
int LED_Blue = 2;                                                     // Blue LED
int PushSW1 = 1;                                                      // PWMフィードバック1　アナログ入力ピン

void setup() {
  // put your setup code here, to run once:
  
  pinMode(LED_Blue, OUTPUT);

  lcd.begin(16,2);                                                    // LCD表示範囲指定
  lcd.clear();                                                        // LCDクリアー

  lcd.setCursor(0,0);                                                 
  lcd.print("Hello ArduinoUNO");

  delay(2000);                                                      // ディレイ2s
  lcd.clear();
}

void loop() {
  // put your main code here, to run repeatedly:

    Volume_val = analogRead(Volume);
    sprintf(buff, "%4d%",Volume_val); 
    lcd.setCursor(0,1);
    lcd.print(buff);
    
    if(analogRead(PushSW1) <= 512){                                   // スイッチ読み込み(アナログポート)、値が半分以下なら。。。
      digitalWrite(LED_Blue,0);                                       // ブルーLEDのポートを0(点灯)する

      lcd.setCursor(0,0);
      lcd.print("ON ");
    }
    else{                                                             // 上記ifが真でなければ。。。
      digitalWrite(LED_Blue,1);                                       // ブルーLEDのポートを1(消灯)する

      lcd.setCursor(0,0);
      lcd.print("OFF");
    }
}
