// ++++++++++++++++++++++++++++++++++++++++
// +++++  Serial Command Control  +++++++++
// ++++++++++++++++++++++++++++++++++++++++
void Serial_cont(){
    int index = 0;
    int hasData = false;

    while (Serial.available() > 0 && index <= 2){
        hasData = true;
        sbuff[index] = Serial.read();
        index++;
    }
    if(hasData == true){
        switch(sbuff[0]){
            case 'V':                                                             // Volume値の受信処理
                serial_flg = 1;                                                   // シリアル受信フラグをセット
                volume_val = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30))*10;
                FB_int = 1;                                                       // Volume値受信で起動するため
                break;
            case 'D':                                                             // 進行方向の受信処理
                serial_flg = 1;                                                   // シリアル受信フラグをセット
                if(sbuff[2] - 0x30 == 0){
                  Dig = 0;
                  FB_int = 1;                                                     // 進行方向SWを倒した時に起動させるため
                }
                else if(sbuff[2] - 0x30 == 1){
                  Dig = 1;
                  FB_int = 1;                                                     // 進行方向SWを倒した時に起動させるため
                }
                else{
                  Dig = 2;                                                        // Stop受信処理
                  auto_d = 0;                                                     // auto_dフラグは"0"にする(Manualにする)
                  sen_flg = 0;                                                    // Sensor検出フラグクリアー
                  Gmode_bak = 0;                                                  
                  Rom_Gain_bak = 10;                                              
                  //serial_flg = 0;
                }
                break;
            case 'M':                                                             // Mode Set受信処理 自動運転のモードセット
                serial_flg = 1;
                Mode_set1 = (sbuff[2] - 0x30);
                EEPROM.write(4, Mode_set1);
                break;                                                            // 現時点組み込みなし
            case 'T':                                                             // Stop Time受信処理 自動運転の停止時間セット
                serial_flg = 1;
                Stop_time1 = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30));
                EEPROM.write(5, Stop_time1);                                       // EEPROMに保存               
                break;                                                            // 現時点組み込みなし
            case 'A':                                                             // Acc/Dec受信処理 自動運転の加速レートセット
                serial_flg = 1;
                Rate_set1 = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30));
                EEPROM.write(3, Rate_set1);                                        // EEPROMに保存 
                break;                                                            // 現時点組み込みなし
            case 'L':                                                             // Light On Set受信処理
                serial_flg = 1;
                Rom_Light = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30))*10;
                EEPROM.write(1, Rom_Light);                                       // EEPROMに保存
                break;                                                            // 現時点組み込みなし
            case 'G':                                                             // Gain Set受信処理 自動運転のゲインセット  
                serial_flg = 1;
                Rom_Gain = ((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30);
                EEPROM.write(0, Rom_Gain);
                break;                                                            // 現時点組み込みなし
            case 'F':                                                             // Gain Set受信処理 自動運転のゲインセット  
                serial_flg = 1;
                Gmode = (sbuff[2] - 0x30);
                EEPROM.write(2, Gmode);
                break;
            case 'E':                                                             // Serialコントロール終了
                serial_flg = 0;                                                   // シリアル受信フラグをリセット
                                                                                  // 方向スイッチをStopにするとシリアルフラグはリセットされる
                break;
        }
    }
}
