// PWM周波数設定
void PWM_frequency_set(){

    //int Delay_FB_time = 0;
    //int Delay_FB = 0;
    //int Non_FB = 0;

    if(PWM_Rate == 0){                                                      // 周期8.2ms
        TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比256
                                                                            // 16,000,000 / (256 x 255 x 2) = 122Hz
                                                                            //              TCCR1  OCR1
        TCCR1B = B00000100;                                                 // 256分周
        Delay_FB_time = 1000;                                               // PWM立下りエッジからFB電圧測定までの待ち時間(us)
        prescaler = 4;                                                      // PWMで使用しているプリスケーラ分周率
        frq_co = 14;
    }
    else if(PWM_Rate == 1){                                                 // 周期2.05ms (周期が短いためFBを入れているとDutyは最大50%までしか上がらない)
        TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比64 (長編成、出力大き目の車両は使用できない)
                                                                            // 16,000,000 / (64 x 255 x 2 ) = 490Hz
        TCCR1B = B00000011;                                                 // 64分周
        Delay_FB_time = 800;                                                // PWM立下りエッジからFB電圧測定までの待ち時間(us)
        prescaler = 4;                                                      // PWMで使用しているプリスケーラ分周率
        frq_co = 28;
    }
    else{                                                                   // 周期4.1ms (周期が短いためFBを入れているとDutyは最大75%までしか上がらない)
        TCCR1A = B00000001;                                                 // Mode5(Fast PWM 8bit) 分周比256
                                                                            // 16,000,000 / (256 x 255 ) = 244Hz
        TCCR1B = B00001100;                                                 // 256分周
        Delay_FB_time = 1000;                                               // PWM立下りエッジからFB電圧測定までの待ち時間(us)
        prescaler = 4;                                                      // PWMで使用しているプリスケーラ分周率
        frq_co = 17;
    }
  
//#define PWM_Mode1_122Hz                                               // 周期8.2ms
//#define PWM_Mode2_244Hz                                               // 244Hzがフィードバック動作として適正周波数。周期4.1ms
//#define PWM_Mode5_244Hz                                                 // 周期4.1ms
//#define PWM_Mode1_490Hz                                               // 高速側ではフィードバックが効かない。周期2.05ms
//#define PWM_Mode5_980Hz                                               // 980Hzぐらいからはフィードバック動作は不安定。周期1.0ms
//#define PWM_Mode2_1960Hz                                              // ここからはフィードバック処理と割り込み処理は行かなくなる。周期0.5ms
//#define PWM_Mode1_3920Hz                                              // 周期255us
//#define PWM_Mode5_7840Hz                                              // 周期128us
//#define PWM_Mode2_15680Hz                                             // ほぼ可聴音は聞こえなくなる。周期64us
//#define PWM_Mode1_31360Hz                                             // モータドライバのターンオフディレイが10us程度あるので実使用は不可能。周期32us

                                                                        // PWM設定
                                                                        // http://garretlab.web.fc2.com/arduino/inside/hardware/arduino/avr/cores/arduino/wiring_analog.c/analogWrite.html
#ifdef PWM_Mode1_122Hz
    TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比256
    TCCR1B = B00000000;                                                 // 16,000,000 / (256 x 255 x 2) = 122Hz
                                                                        //              TCCR1  OCR1
    TCCR1B |= B00000100;                                                // 256分周

    //EEPROM.write(0, 5);                                               // Gain値をEEPROMに保存(0-10)
    //Rom_Gain = 5;                                                     // Gain値の変数を"5"にする
    
    Delay_FB_time = 1000;
    prescaler = 4;
    //Delay_FB = 7000;
    //Non_FB = 0;
#endif

#ifdef PWM_Mode2_244Hz
    TCCR1A = B00000010;                                                 // Mode2(Phase Correct 9bit) 分周比256
    TCCR1B = B00000000;                                                 // 16,000,000 / (256 x 511 x 2 ) = 244Hz

    TCCR1B |= B00000011;                                                // 64分周

    Delay_FB_time = 1000;
    prescaler = 2;
    //Delay_FB = 3500;
    //Non_FB = 0;
#endif

#ifdef PWM_Mode5_244Hz
    TCCR1A = B00000001;                                                 // Mode5(Fast PWM 8bit) 分周比256
    TCCR1B = B00001000;                                                 // 16,000,000 / (256 x 255 ) = 244Hz

    TCCR1B |= B00000100;                                                // 256分周

    Delay_FB_time = 1000;
    prescaler = 4;
    //Delay_FB = 3500;
    //Non_FB = 0;
#endif

#ifdef PWM_Mode1_490Hz
    TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比64
    TCCR1B = B00000000;                                                 // 16,000,000 / (64 x 255 x 2 ) = 490Hz

    TCCR1B |= B00000011;                                                // 64分周

    Delay_FB_time = 1000;
    prescaler = 4;
    //Delay_FB = 1750;
    //Non_FB = 0;
#endif

#ifdef PWM_Mode5_980Hz
    TCCR1A = B00000001;                                                 // Mode5(Fast PWM 8bit) 分周比64
    TCCR1B = B00001000;                                                 // 16,000,000 / (64 x 255 ) = 980Hz

    TCCR1B |= B00000011;                                                // 64分周

    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない
    
    Delay_FB_time = 500;
    prescaler = 4;
    //Delay_FB = 875;
    //Non_FB = 0;
#endif

#ifdef PWM_Mode2_1960Hz
    TCCR1A = B00000010;                                                 // Mode2(Phase Correct 9bit) 分周比8
    TCCR1B = B00000000;                                                 // 16,000,000 / (8 x 511 x 2 ) = 1960Hz

    TCCR1B |= B00000010;                                                // 8分周

    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない
    
    Delay_FB_time = 0;
    prescaler = 2;
    //Delay_FB = 437;
    //Non_FB = 1;
#endif

#ifdef PWM_Mode1_3920Hz
    TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比8
    TCCR1B = B00000000;                                                 // 16,000,000 / (8 x 255 x 2 ) = 3920Hz

    TCCR1B |= B00000010;                                                // 8分周
    
    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない
    
    Delay_FB_time = 0;
    prescaler = 4;
    //Delay_FB = 218;
    //Non_FB = 1;
#endif

#ifdef PWM_Mode5_7840Hz
    TCCR1A = B00000001;                                                 // Mode5(Fast PWM 8bit) 分周比8
    TCCR1B = B00001000;                                                 // 16,000,000 / (8 x 255 ) = 7840Hz

    TCCR1B |= B00000010;                                                // 8分周
    
    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない

    Delay_FB_time = 0;
    prescaler = 4;
    //Delay_FB = 109;
    //Non_FB = 1;
#endif

#ifdef PWM_Mode2_15680Hz
    TCCR1A = B00000010;                                                 // Mode2(Phase Correct 9bit) 分周比1
    TCCR1B = B00000000;                                                 // 16,000,000 / (1 x 511 x 2 ) = 15680Hz

    TCCR1B |= B00000001;                                                // 1分周

    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない
    
    Delay_FB_time = 0;
    prescaler = 2;
    //Delay_FB = 54;
    //Non_FB = 1;
#endif

#ifdef PWM_Mode1_31360Hz
    TCCR1A = B00000001;                                                 // Mode1(Phase Correct 8bit) 分周比1
    TCCR1B = B00000000;                                                 // 16,000,000 / (1 x 255 x 2 ) = 31360Hz

    TCCR1B |= B00000001;                                                // 1分周

    EEPROM.write(0, 0);                                                 // 周波数が早い時にはGain値を0として
    Rom_Gain = 0;                                                       // Feed Backを使わない
    
    Delay_FB_time = 0;
    prescaler = 4;
    //Delay_FB = 54;
    //Non_FB = 1;
#endif

    //TCCR1A = B00000011;                                                 // Mode11
    //TCCR1B = B00011000;                                                 // 16,000,000 / (1 x 65535 x 2) = 122.070Hz    

    //TCCR1B &= B11111000;                                                // Timer1 Clock Chenge
    //TCCR1B |= B00000100;                                                // PWM 122.5Hz (256分周)
    //TCCR1B |= B00000011;                                                // PWM 490Hz (64分周)
    //TCCR1B |= B00000010;                                                // PWM 3920Hz (8分周)
    //TCCR1B |= B00000001;                                                // PWM 31360Hz (1分周)
}
