// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                      P'sTec Higuma
//              Ardino UNO Power Pack Soft
//                      Feedback
//                      Auto
//                                      2022/10/20
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//		
//
//    Port Set
//      D0    RS_RX  *LED_Orenge          AD0   Volume
//      D1    RS_TX  *LED_Blue            AD1   PWM_FB1
//      D2    INT_PWM1                    AD2   PWM_FB2
//      D3    INT_PWM2                    AD3   SW_MODE
//      D4    SW_FOR                      AD4   Sensor_1
//      D5    SW_REV                      AD5   Sensor_2
//      D6    LCD_E
//      D7    LCD_RS 
//      D8    LCD_D4
//      D9    PWM_OUT1
//      D10   PWM_OUT2
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7

#include <LiquidCrystal.h>
#include <EEPROM.h>

LiquidCrystal lcd(7, 6, 8, 11, 12, 13);                                 //　LCDポート設定

volatile int state = FALLING;                                           // 割り込みは立ち下がりで発生
// ----- Port割り当て 変数 -----
int LED_Orenge = 0;                                                     // Orenge LED出力ピン
int LED_Blue = 1;                                                       // Blue LED出力ピン
int INT_PWM1 = 2;                                                       // PWM1割り込み入力ピン
int INT_PWM2 = 3;                                                       // PWM2割り込み入力ピン
int SW_FOR = 4;                                                         // SW_FOR入力ピン
int SW_REV = 5;                                                         // SW_REV入力ピン
int PWM_OUT1 = 9;                                                       // PWM_OUT1(For方向)出力ピン
int PWM_OUT2 = 10;                                                      // PWM_OUT2(Rev方向)出力ピン
int Volume = 0;                                                         // ボリューム　アナログ入力ピン
int PWM_FB1 = 1;                                                        // PWMフィードバック1　アナログ入力ピン
int PWM_FB2 = 2;                                                        // PWMフィードバック2　アナログ入力ピン
int SW_MODE = 17;                                                       // SW_MODE　デジタル入力ピン
int Sensor_1 = 4;                                                       // Sensor1 アナログ入力ピン
int Sensor_2 = 5;                                                       // Sensor2 アナログ入力ピン

    // ----- EEPROM 変数 -----
int Rom_Gain = 0;                                                       // ゲイン値(EEPROM保存値)
int Rom_Gain_bak = 10;                                                  // 一回前のゲイン値(EEPROM保存値)
int Rom_Light = 0;                                                      // 常点灯値(EEPROM保存値)
int Gmode = 10;                                                         // ゲインモード
int Gmode_bak = 10;                                                     // 一回前のゲインモード
int Rate_set1 = 10;                                                     // Serial加減速レート1時間(センサー1)
int Acc_rate1 = 10;                                                     // 加速周期1時間(センサー1)
int Dec_rate1 = 10;                                                     // 減速周期1時間(センサー1)
int Rate_set2 = 10;                                                     // Serial加減速レート2時間(センサー2)
int Acc_rate2 = 10;                                                     // 加速周期2時間(センサー2)
int Dec_rate2 = 10;                                                     // 減速周期2時間(センサー2)
int Mode_set1 = 0;                                                      // 動作モード1(センサー1)(0:往復モード　1:直進モード)
int Mode_set2 = 0;                                                      // 動作モード2(センサー2)(0:往復モード　1:直進モード)
int Stop_time1 = 10;                                                    // 停車1時間(センサー1)
int Stop_time2 = 10;                                                    // 停車2時間(センサー2)
int PWM_Rate = 2;                                                       // PWM周波数(244Hz)

char buff[16];                                                          // 変数 LCD表示文字変数
char sbuff[8];															                            // シリアル通信文字変数
int volume_val = 0;                                                     // ボリューム読み込み値
int volume_val_auto ; 
int volume_val_bak = -10;                                               // 一回前のボリューム読み込み値
int serial_flg = 0;                                                     // ボリュームの読み込み許可フラグ
int Dig = 2;                                                            // 進行方向フラグ
int Dig_bak = 3;                                                        // 一回前の進行方向フラグ
int val_fb = 0;                                                         // フィードバック積算値
int val_fb_chk = 0;                                                     // フィードバック出力値
int val_fb_chk_bak = -10;                                               // 一回前のフィードバック出力値
int Sen1 = 0;                                                           // センサー1読み込み値
int Sen2 = 0;                                                           // センサー2読み込み値
int sen_flg = 0;                                                        // センサーフラグ
int auto_d = 0;                                                         // "0" = Manual  "1" = Auto Drive
int n = 0;                                                              // 自動運転減速時変数
int GainN = 50;                                                         // 読み込み周回値
int val_out = 0;                                                        // PWM出力値
int val_out_bak = -10;                                                  // 一回前のPWM出力値
int FB_Read = 0;                                                        // フィードバック電圧読み出し値
int Accel = 0;                                                          // 自動運転加速時変数
int Sen1_flg = 0;                                                       // センサー1フラグ
int Sen2_flg = 0;                                                       // センサー2フラグ

int Slice_level = 613;                                                  // プッシュスイッチ、センサーのHi/Lowスライスレベル(ADCポートのため)
int Hysteresis = 30;                                                    // プッシュスイッチ、線さーのヒステリシス(0.1V)
int FB_int = 1;                                                         // フィードバック割り込みフラグ
int Stop_Loop = 0;                                                      // 停車時間処理変数

//char Serial_val[255];
int Serial_val;
int Delay_FB_time = 0;
int prescaler = 4;
int frq_co = 1;
int ssc = 0;
int Sensor_out = 0;
int flg1 = 0;

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          SetUP INIT            \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void setup() {
    Serial.begin(115200);                                               // シリアルの設定 (115200bps,8bit,None,1)
                                                                        // シリアルを有効にした場合にはLED_OrengeとLED_Blueのポートは共通の為、
                                                                        // LEDのON/OFFは無効となる
    lcd.begin(16,2);                                                    // LCD表示範囲指定
 
    pinMode(LED_Orenge, OUTPUT);                                        // 各ポート設定
    pinMode(LED_Blue, OUTPUT);
    pinMode(PWM_OUT1, OUTPUT);
    pinMode(PWM_OUT2, OUTPUT);
    pinMode(SW_FOR, INPUT);
    pinMode(SW_REV, INPUT);
	  pinMode(SW_MODE, INPUT);
    pinMode(INT_PWM1, INPUT_PULLUP);
    pinMode(INT_PWM2, INPUT_PULLUP);

    digitalWrite(LED_Orenge, LOW);
    attachInterrupt(0,int_FOR, FALLING);
    attachInterrupt(1,int_REV, FALLING);
    // ----- EEPROMデータ読み出し -----
    EEPROM_read();                                                      // EEPROM設定値読み出し

    // ----- Clock Select -----
    Clock_Select();
    
    // ----- Sensor self check -----
    Sensor_self_check();                                                // Sensor_self_check

    // ----- PWM frequncy set -----
    PWM_frequency_set(); 
    
/*
    TCCR1B &= B11111000;                                                // Timer1 Clock Chenge
    TCCR1B |= B00000100;                                                // PWM 122.5Hz
    //TCCR1B |= B00000011;                                                // PWM 490Hz
    //TCCR1B |= B00000010;                                                // PWM 3920Hz    
*/                                                                      // 周波数変更する場合には、割り込み内のフィードバック待ち時間を変更する必要あり
   
    // ----- LCDオープニング画面表示 -----

    lcd.setCursor(0,0);                                                 //　オープニング画面
    lcd.print("P'sTec   Arduino");                                      //
    lcd.setCursor(0,1);                                                 //
    lcd.print("  PPack Rev.0.40");                                      //
  
    delay(2000);                                                        // 表示時間2s
 
    // &&&&&&&&&&&&&&&&&&&
    //    LCDの初期表示
    // &&&&&&&&&&&&&&&&&&&
    
    lcd.clear();                                                        // LCDクリアー
    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Vol");                                                   // "Vol"LCD表示
    lcd.setCursor(9,1);                                                 // カーソルを2行目10文字目
    lcd.print("FB");                                                    // "FB"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Out");                                                   // "Out"LCD表示
    lcd.setCursor(8,0);                                                 // カーソルを1行目10文字目
    if(Gmode == 3){                                                     // ゲインモードが"3"(Normal)なら
        lcd.print(" N");                                                // "N"(Normal)を表示
    }
    else if(Gmode == 1){                                                // ゲインモードが"1"(Coreless)なら
        lcd.print(" C");                                                // "C"(Cor-Less)を表示
    }
    else if(Gmode == 6){                                                // ゲインモードが"6"(Slow)なら
        lcd.print(" S");                                                // "S"(Slow)を表示
    }
    attachInterrupt(0,int_FOR, FALLING);                                // FOR側フィードバック割り込み開始
    attachInterrupt(1,int_REV, FALLING);                                // REV側フィードバック割り込み開始
 }

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          MAIN LOOP             \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
void loop() {
    noInterrupts();                                                     // 割込み停止

    if(serial_flg == 0){                                                // Volumeフラグが0なら(Serial cont用)
        volume_val = analogRead(Volume);                                // Volume入力読み込み Max 1023
        volume_val = volume_val *0.8;                                   // 最大値80%とするもの
        if(volume_val >= 800){
          volume_val = 800;                                             // 上限値設定(800) 80%
        }
    }
    if(Rom_Gain == 0){                                                  // フィードバックゲインが"0"の時には割り込み停止したままとする
		    FB_int = 1;                                                     // 
        Sen1 = analogRead(Sensor_1);                                    // Sensor_1入力読み込み Max1023
        Sen2 = analogRead(Sensor_2);                                    // Sensor_2入力読み込み Max1023
	  }
	  else{
   		  interrupts();                                                   // フィードバックゲインが"0"の時には割り込み停止したままとする
	  }
    if(Dig != 2 && serial_flg == 0){                                                       // スイッチがSTOPでなければ
        Sensor_on();                                                    // Sensor入力確認
    }

    if( digitalRead(SW_MODE) == 0){                                     // PushSWが押されたら進行方向スイッチにより各設定に移動
        while( digitalRead(SW_MODE) == 0){                              // PushSW MODEが離されたら。。。
        }
        if( digitalRead(SW_FOR) == 0){                                  // SW_FORになったいたら。。。
            Light_on_set();                                             // 常時点灯の設定へ。。。
        }
        else if( digitalRead(SW_REV) == 0){                             // SW_REVになっていたら。。。
            Gain_set();                                                 // ゲインの設定へ。。。
        }
        else if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){ // SW_STPになっていたら。。。
            AD_Rate_set();                                              // 加減速レートへ。。。
        }
    }
 
    // 方向SW読み込み
    if(auto_d == 0 && serial_flg == 0){                                 // auto_dフラグが0の時は。。。
        if(Dig == 2){
          FB_int = 1;
        }
        if( digitalRead(SW_FOR) == 0){ Dig = 0; }                       // SW_FORになっていたらDigは"0"にする
        if( digitalRead(SW_REV) == 0){ Dig = 1; }                       // SW_REVになっていたらDigは"1"にする
    }
    if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){          // SW_STOPになっていたらDigは"2"にする
        Dig = 2;
        auto_d = 0;                                                     // auto_dフラグは"0"にする(Manualにする)
        serial_flg = 0;
        sen_flg = 0;                                                    // Sensor検出フラグクリアー
        Gmode_bak = 0;                                                  // 一回前のGmodeを0にセット(無い値にセットし書き換えのため)
        Rom_Gain_bak = 10;                                              // 一回前のフィードバックゲイン値を10にセット(無い値にセットし書き換えのため)
        FB_int = 1;
        Sensor_out = 0;                                                 // 自動運転からの発車時センサースルー時間クリアー
    }
    
    Serial_cont();                                                	    // *シリアル通信コントロール
    FB_out();                                                           // フィードバック編集し出力
	  Disp_LCD();                                                         // *LCD表示

	delay(1);
}
