 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Light On Set         \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Light_on_set(){                                                    // 常時点灯の設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止
    val_fb = 0;                                                         // Feedback値クリアー
    
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Light On Set");                                          // "Light On Set"LCD表示

    Rom_Light = EEPROM.read(1);                                         // EEPROMに保存してある常時点灯値を読み込み
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    sprintf(buff,"Set%3d%%",Rom_Light/10);                              // EEPROMに保存された常点灯値を編集
    lcd.print(buff);                                                    // 編集された常点灯値を表示
    
    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        // analogRead Max1023(SW押下で"0")
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d%%",volume_val/40);                            // Volume値を1/40としLCD表示用にする(max25)
        lcd.setCursor(12,1);                                            // カーソルを1行目11文字目
        lcd.print(buff);                                                // Volume値をLCDに表示

        if(digitalRead(SW_FOR) == 0){                                   // 進行方向フラグfor"0"
            analogWrite(PWM_OUT1, volume_val/40);                       // PWM_OUT1へ出力
            analogWrite(PWM_OUT2, 0);                                   // PWM_OUT2をPWM停止
        }
        else if(digitalRead(SW_REV) == 0){                              // 進行方向フラグRev"1"
            analogWrite(PWM_OUT2, volume_val/40);                       // PWM_OUT2へ出力
            analogWrite(PWM_OUT1, 0);                                   // PWM_OUT1をPWM停止
        }
        else{                                                           // 進行方向フラグRev"2"
            analogWrite(PWM_OUT1, 0);                                   // PWM_OUT1をPWM停止
            analogWrite(PWM_OUT2, 0);                                   // PWM_OUT2をPWM停止
        }
    }
    if(volume_val >= 1000){                                             // valが1000以上なら
        volume_val = 1000;                                              // 1000にする
    }
    EEPROM.write(1, volume_val/4);                                      // 25%のボリューム値をEEPROMに保存
    Rom_Light = volume_val/4;

    Set_return();                                                       // 設定終了処理へ
}
