 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Gain Set             \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Gain_set(){                                                        // Feedback Gain設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止
    val_fb = 0;                                                         // Feedback値クリアー
    
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Gain Set (0-9)");                                        // "Gain Set"LCD表示

    Rom_Gain = EEPROM.read(0);                                          // EEPROMに保存してあるGain値を読み込み
    sprintf(buff,"Set%2d",Rom_Gain);
    lcd.setCursor(7,1);                                                 // カーソルを2行目8文字目
    lcd.print(buff);                                                    // EEPROMに保存してあったGain値をLCD表示
    if(Rom_Gain == 0){                                                  // フィードバックゲイン値が0なら
        lcd.setCursor(10,1);                                            // カーソルを2行目11文字目
        lcd.print(" N");                                                // " N"を上書き
    }
    
    while( digitalRead(SW_MODE) == 0){                                   // PushSWが離されるまでループ
    }                                                                   // 
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                   // PushSWが押下されるまでループ
                                                                        // 
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        lcd.setCursor(13,1);                                            // カーソルを1行目14文字目
        if(volume_val/113 <= 0){
            lcd.print("Non");
        }
        else{
            sprintf(buff,"%3d",volume_val/113);                         // Volume値を1/113としLCD表示用にする(max9)
            lcd.print(buff);                                            // Volume値をLCDに表示
        }
        lcd.setCursor(0,1);                                             // カーソルを2行目1文字目
        if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
            Gmode = 6;                                                  // ゲインモードを"6"とする
            lcd.print("Slow  ");                                        // "Slow"を表示(超低速走行用)
        }
        else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
            Gmode = 1;                                                  // ゲインモードを"1"とする
            lcd.print("CoLess");                                        // "CoLess"を表示(Coreless Motor)
        }
        else{
            Gmode = 3;                                                  // ゲインモードを"3"とする
            lcd.print("Normal");                                        // "Normal"を表示(通常モーター)
        }
    }                                                                 
    EEPROM.write(0, volume_val/113);                                    // Gain値をEEPROMに保存(0-10)
    Rom_Gain = volume_val/113;                                          // Gain値をRom_Gainにする
    EEPROM.write(2,Gmode);                                              // ゲインモードをEEPROMに保存(1,3,6)

    Set_return();                                                       // 設定終了処理へ
}
