    // '''''''''''''''''''''''''''''
    // EEPROMの保存値チェックと読み出し
    // '''''''''''''''''''''''''''''
void EEPROM_read(){
    Rom_Gain = EEPROM.read(0);                                          // Gain値をEEPOMの(0)から読み出し
    if(Rom_Gain >= 10){                                                 // Gain値が11以上なら(設定させていない時の処理)
        EEPROM.write(0, 5);                                             // Gain値をEEPROMに保存(0-10)
        Rom_Gain = 5;                                                   // Gain値の変数を"5"にする
    }
    
    Rom_Light = EEPROM.read(1);                                         // 常点灯値をEEPROMの(1)から読み出し
    if(Rom_Light >= 255){                                               // 常点灯値が255以上なら
        EEPROM.write(1,0);                                              // 常点灯値をEEPROMに保存(0-255)
        Rom_Light = 0;                                                  // 常点灯値の変数を"0"にする
    }
    
    Gmode = EEPROM.read(2);                                             // ゲインモードをEEPOMの(2)から読み出し
    if(Gmode >= 10){                                                    // ゲインモードが10以上なら(設定させていない時の処理)
        EEPROM.write(2, 3);                                             // ゲインモード値をEEPROMに保存(1,3,6)
        Gmode = 3;                                                      // ゲインモードの変数を"3"にする
    }
    
    Acc_rate1 = EEPROM.read(3);                                         // 加減速レートをEEPOMの(3)から読み出し
    if(Rate_set1 >= 51){                                                // 加減速レートが21以上なら(設定させていない時の処理)
        EEPROM.write(3,10);                                             // 加減速レートをEEPROMに保存(0-48)
        Acc_rate1 = 10;                                                 // 加減速レートの変数を"10"にする
    }
    
    Dec_rate1 = EEPROM.read(4);                                         // 加減速レートをEEPOMの(4)から読み出し
    if(Rate_set1 >= 51){                                                // 加減速レートが21以上なら(設定させていない時の処理)
        EEPROM.write(4,10);                                             // 加減速レートをEEPROMに保存(0-48)
        Dec_rate1 = 10;                                                 // 加減速レートの変数を"10"にする
    }
    
    Mode_set1 = EEPROM.read(5);                                         // 自動運転モードをEEPROMの(5)から読み出し
    if(Mode_set1 >= 10){                                                // 自動運転モードが10以上なら(設定させていない時の処理)
        EEPROM.write(5,0);                                              // 自動運転モードをEEPROMに保存(0-2)
        Mode_set1 = 0;                                                  // 自動運転モードの変数を"0"にする
    }
    
    Stop_time1 = EEPROM.read(6);                                        // 自動運転時の停車時間をEEPROMの(6)から読み出し
    if(Stop_time1 >= 301){                                              // 自動運転時の停車時間が21以上なら(設定させていない時の処理)
        EEPROM.write(6,10);                                              // 自動運転時の停車時間をEEPROMに保存(0-300)
        Stop_time1 = 10;                                                // 自動運転時の停車時間を"10"にする
    }
    
    PWM_Rate = EEPROM.read(7);                                          // PWMの周波数をEEPORMから読み出し
    if(PWM_Rate >= 3){                                                  // "0" 122Hz
        EEPROM.write(7,2);                                              // "1" 490Hz
        PWM_Rate = 2;                                                   // "2" 240Hz
    }

    Acc_rate2 = EEPROM.read(8);                                         // 加減速レートをEEPOMの(8)から読み出し
    if(Rate_set2 >= 51){                                                // 加減速レートが21以上なら(設定させていない時の処理)
        EEPROM.write(8,10);                                             // 加減速レートをEEPROMに保存(0-48)
        Acc_rate2 = 10;                                                 // 加減速レートの変数を"10"にする
    }
    
    Dec_rate2 = EEPROM.read(9);                                         // 加減速レートをEEPOMの(9)から読み出し
    if(Rate_set2 >= 51){                                                // 加減速レートが21以上なら(設定させていない時の処理)
        EEPROM.write(9,10);                                             // 加減速レートをEEPROMに保存(0-48)
        Dec_rate2 = 10;                                                 // 加減速レートの変数を"10"にする
    }

    Mode_set2 = EEPROM.read(10);                                        // 自動運転モードをEEPROMの(10)から読み出し
    if(Mode_set2 >= 10){                                                // 自動運転モードが10以上なら(設定させていない時の処理)
        EEPROM.write(10,0);                                              // 自動運転モードをEEPROMに保存(0-2)
        Mode_set2 = 0;                                                  // 自動運転モードの変数を"0"にする
    }
    
    Stop_time2 = EEPROM.read(11);                                       // 自動運転時の停車時間をEEPROMの(11)から読み出し
    if(Stop_time2 >= 301){                                              // 自動運転時の停車時間が21以上なら(設定させていない時の処理)
        EEPROM.write(11,10);                                              // 自動運転時の停車時間をEEPROMに保存(0-300)
        Stop_time2 = 10;                                                // 自動運転時の停車時間を"10"にする
    }
}
