// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Display LCD                  \**/\**/
 // \**/\**/  LCDの書き込みは１回で10ms程度かかるため    \**/\**/
 // \**/\**/    メインループ内では不要部分を上書き       \**/\**/
 // \**/\**/      しないよう処理しています。　　　　　　　\**/\**/
 // \**/\**/      全てを書き込みすると60ms 　　　　　　　\**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/\**/\**/
void Disp_LCD(){
    if(volume_val / 10 != volume_val_bak / 10 || volume_val == 0){      // 一回前のVolume値と違っていたら
        lcd.setCursor(3,0);                                             // カーソルを1行目4文字目
        sprintf(buff, "%4d%%", volume_val / 10);                        // Volume値
        lcd.print(buff);                                                // 表示
        volume_val_bak = volume_val;                                    // Volume値を一回前の変数に入れる
    }
    if(val_out / 10 != val_out_bak / 10 || val_out == 0){               // 一回前の出力値と違っていたら
        lcd.setCursor(3,1);                                             // カーソルを2行目4文字目
        sprintf(buff, "%4d%%", val_out / 10);                           // PWM出力値
        lcd.print(buff);                                                // 表示
        val_out_bak = val_out;                                          // 出力値を一回前の変数に入れる
    }
    if(val_fb_chk / 10 != val_fb_chk_bak / 10 || val_fb_chk == 0){      // 一回前のフィードバック値と違っていたら
        lcd.setCursor(12,1);                                            // カーソルを2行目13文字目
        sprintf(buff, "%3d%%", val_fb_chk / 10);                        // フィードバック値
        lcd.print(buff);                                                // LCD表示
        
        sprintf(buff, "F%2d%", val_fb_chk / 10);                        // フィードバック値シリアル送信
        Serial.println(buff);                                           // fb値シリアル出力
        
        val_fb_chk_bak = val_fb_chk;                                    // フィードバック値を一回前の変数に入れる
    }
    if(auto_d == 0){                                                    // オートでなければ。。。(Auto_d = 0ならマニュアル)
        lcd.setCursor(11,0);                                            // カーソルを1行目12文字目
        if(Dig == 0){                                                   // 方向スイッチフラグがFront
            lcd.print("  FOR");                                         // LCD表示"FOR"
        }
        else if(Dig == 1){                                              // 方向スイッチフラグがReverse
            lcd.print("  REV");                                         // LCD表示"REV"
        }
        else if(Dig == 2){                                              // 方向スイッチフラグがSTOP
            lcd.print(" STOP");                                         // LCD表示"STOP"
        }
        Dig_bak = Dig;                                                  // 方向フラグを一回前の変数にいれる

        if(Gmode != Gmode_bak){                                         // ゲインモードが一回前のモードと違っていたら
            lcd.setCursor(8,0);                                         // カーソルを1行目9文字目
            if(Gmode == 3){                                             // ゲインモードが"3"(Normal)なら
                lcd.print(" N");                                        // "N"を表示
            }
            else if(Gmode == 1){                                        // ゲインモードが"1"(Coreless)なら
                lcd.print(" C");                                        // "C"を表示
            }
            else if(Gmode == 6){                                        // ゲインモードが"6"(Slow)なら
                lcd.print(" S");                                        // "S"を表示
            }
            else{                                                       // ゲインモードが上記以外なら
                sprintf(buff,"%2d",Gmode);                              // ゲインモードの倍率表示
                lcd.print(buff);                                        // Gmode値を表示
            }
            Gmode_bak = Gmode;                                          // ゲインモードを一回前の変数にいれる
        }
        if(Rom_Gain != Rom_Gain_bak){                                   // フィードバックゲインが一回前のゲインと違っていたら
            lcd.setCursor(10,0);                                        // カーソルを1行目11文字目
            lcd.print(Rom_Gain);                                        // フィードックゲイン値を表示
            Rom_Gain_bak = Rom_Gain;                                    // フィードバックゲインを一回前の変数にいれる
        }
    }
}
