 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      動作モード/加減速Rate Set   \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void AD_Rate_set(){                                                     // 加減速Rateの設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止

    val_fb = 0;                                                         // Feedback値クリアー

// ************** Sensor1側の各動作設定 *****************
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Mode Set1");                                             // "Rate Set"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを1行目1文字目
    lcd.print("StopTime1");                                             // "Stop Time"LCD表示   

    Stop_time1 = EEPROM.read(6);                                        // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3ds%",Stop_time1);                                   // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        if(volume_val >= 900){                                          // Volume最大値を900とする
            volume_val = 900;
        }
        sprintf(buff,"%3ds%",volume_val / 3);                           // Volume値を1/3としLCD表示用にする(max300s)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示

        if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
            Mode_set1 = 0;                                              // 動作モードを"2"とする(Option未設定のためGoTurnにする)
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("Option");                                        // "Option"を表示(動作モード追加部)
        }
        else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
            Mode_set1 = 1;                                              // ゲインモードを"1"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoStop");                                        // "GoStop"を表示(停止→発進)
        }
        else if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){
            Mode_set1 = 0;                                              // ゲインモードを"3"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoTurn");                                        // "GoTurn"を表示(停止→反転発進)
        }
    }
    Stop_time1 = volume_val / 3;                                        // ボリューム値を停車時間変数に入れる

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Acc1             ");                                     // "Rate Set1"LCD表示 
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Rate Set1");                                             // "Rate Set1"LCD表示 

                                                                        // 加速減速率のレート設定
    Acc_rate1 = EEPROM.read(3);                                         // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3d %",Acc_rate1);                                    // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d %",volume_val / 21);                          // Volume値を1/21としLCD表示用にする(max48)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示
    }
    Acc_rate1 = volume_val /21;                                         // ボリューム値から加減速レートへ入れる          

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Dec1             ");                                     // "Rate Set1"LCD表示 
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Rate Set1");                                             // "Rate Set1"LCD表示 

                                                                        // 加速減速率のレート設定
    Dec_rate1 = EEPROM.read(4);                                         // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3d %",Dec_rate1);                                    // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d %",volume_val / 21);                          // Volume値を1/21としLCD表示用にする(max48)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示
    }
    Dec_rate1 = volume_val /21;                                         // ボリューム値から加減速レートへ入れる 
// ************** Sensor2側の各動作設定 *****************
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Mode Set2");                                             // "Rate Set"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを1行目1文字目
    lcd.print("StopTime2");                                             // "Stop Time"LCD表示   

    Stop_time2 = EEPROM.read(11);                                        // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3ds%",Stop_time2);                                   // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        if(volume_val >= 900){                                          // Volume最大値を900とする
            volume_val = 900;
        }
        sprintf(buff,"%3ds%",volume_val / 3);                           // Volume値を1/3としLCD表示用にする(max300s)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示

        if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
            Mode_set2 = 0;                                              // 動作モードを"2"とする(Option未設定のためGoTurnにする)
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("Option");                                        // "Option"を表示(動作モード追加部)
        }
        else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
            Mode_set2 = 1;                                              // ゲインモードを"1"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoStop");                                        // "GoStop"を表示(停止→発進)
        }
        else if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){
            Mode_set2 = 0;                                              // ゲインモードを"3"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoTurn");                                        // "GoTurn"を表示(停止→反転発進)
        }
    }
    Stop_time2 = volume_val / 3;                                        // ボリューム値を停車時間変数に入れる

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Acc2             ");                                     // "Rate Set2"LCD表示 
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Rate Set2");                                             // "Rate Set2"LCD表示 

                                                                        // 加速減速率のレート設定
    Acc_rate2 = EEPROM.read(8);                                         // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3d %",Acc_rate2);                                    // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d %",volume_val / 21);                          // Volume値を1/51としLCD表示用にする(max48)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示
    }
    Acc_rate2 = volume_val /21;                                         // ボリューム値から加減速レートへ入れる 
      
    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Dec2             ");                                     // "Rate Set2"LCD表示 
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Rate Set2");                                             // "Rate Set2"LCD表示 

                                                                        // 加速減速率のレート設定
    Dec_rate2 = EEPROM.read(9);                                         // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3d %",Dec_rate2);                                    // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( digitalRead(SW_MODE) == 0){                                  // PushSWが離されるまでループ
    }                                                                   
    delay(100);                                                         // Delay 100ms
    while( digitalRead(SW_MODE) == 1){                                  // PushSWが押下されるまでループ
                                                                        
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d %",volume_val / 21);                          // Volume値を1/51としLCD表示用にする(max48)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示
    }
    Dec_rate2 = volume_val /21;                                         // ボリューム値から加減速レートへ入れる
                                                                    
    EEPROM.write(3, Acc_rate1);                                         // 加減速時間値をEEPROMに保存(0-48)
    EEPROM.write(4, Dec_rate1);                                         // 加減速時間値をEEPROMに保存(0-48)
    EEPROM.write(8, Acc_rate2);                                         // 加減速時間値をEEPROMに保存(0-48)
    EEPROM.write(9, Dec_rate2);                                         // 加減速時間値をEEPROMに保存(0-48)
    EEPROM.write(5, Mode_set1);                                         // Gain値をEEPROMに保存(0-20)
    EEPROM.write(10, Mode_set2);                                        // Gain値をEEPROMに保存(0-20)
    EEPROM.write(6, Stop_time1);                                        // 停車時間をEEPROMに保存(0-300s)
    EEPROM.write(11, Stop_time2);                                       // 停車時間をEEPROMに保存(0-300s)
    
 	  attachInterrupt(0,int_FOR, FALLING);                                // FOR側フィードバック割り込み開始
    attachInterrupt(1,int_REV, FALLING);                                // REV側フィードバック割り込み開始

    Set_return();                                                       // 設定終了処理へ
}
