// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                      P'sTec Higuma
//              Ardino UNO Power Pack Soft
//                      Feedback
//                      Auto
//                                      2021/8/26
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                        Rev.0.30
//    Port Set
//      D0    RS_RX  *LED_Orenge          AD0   Volume
//      D1    RS_TX  *LED_Blue            AD1   PWM_FB1
//      D2    INT_PWM1                    AD2   PWM_FB2
//      D3    INT_PWM2                    AD3   PushSW
//      D4    SW_FOR                      AD4   Sensor_1
//      D5    SW_REV                      AD5   Sensor_2
//      D6    LCD_E
//      D7    LCD_RS 
//      D8    LCD_D4
//      D9    PWM_OUT1
//      D10   PWM_OUT2
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7

#include <LiquidCrystal.h>
#include <EEPROM.h>

LiquidCrystal lcd(7, 6, 8, 11, 12, 13);                                 //　LCDポート設定

int LED_Orenge = 0;                                                     // Orenge LED出力ピン
int LED_Blue = 1;                                                       // Blue LED出力ピン
int INT_PWM1 = 2;                                                       // PWM1割り込み入力ピン
int INT_PWM2 = 3;                                                       // PWM2割り込み入力ピン
int SW_FOR = 4;                                                         // SW_FOR入力ピン
int SW_REV = 5;                                                         // SW_REV入力ピン
int PWM_OUT1 = 9;                                                       // PWM_OUT1(For方向)出力ピン
int PWM_OUT2 = 10;                                                      // PWM_OUT2(Rev方向)出力ピン
int Volume = 0;                                                         // ボリューム　アナログ入力ピン
int PWM_FB1 = 1;                                                        // PWMフィードバック1　アナログ入力ピン
int PWM_FB2 = 2;                                                        // PWMフィードバック2　アナログ入力ピン
int PushSW = 3;                                                         // PushSW　アナログ入力ピン
int Sensor_1 = 4;                                                       // Sensor1 アナログ入力ピン
int Sensor_2 = 5;                                                       // Sensor2 アナログ入力ピン

volatile int state = RISING;                                            // 割り込みは立ち上がりで発生

char buff[16];                                                          // 変数 LCD表示文字
char sbuff[8];
int volume_val = 0;                                                     // ボリューム読み込み値
int volume_val_bak = -10;                                               // 一回前のボリューム読み込み値
int serial_flg = 0;                                                     // ボリュームの読み込み許可フラグ
int Dig = 2;                                                            // 進行方向フラグ
int Dig_bak = 3;                                                        // 一回前の進行方向フラグ
int val_fb = 0;                                                         // フィードバック積算値
int val_fb_chk = 0;                                                     // フィードバック出力値
int val_fb_chk_bak = -10;                                               // 一回前のフィードバック出力値
int Sen1 = 0;                                                           // センサー1読み込み値
int Sen2 = 0;                                                           // センサー2読み込み値
int sen_flg = 0;                                                        // センサーフラグ
int auto_d = 0;                                                         // "0" = Manual  "1" = Auto Drive
int n = 0;                                                              // 自動運転減速時変数
int GainN = 50;                                                         // 読み込み周回値
int val_out = 0;                                                        // PWM出力値
int val_out_bak = -10;                                                  // 一回前のPWM出力値
int FB_Read = 0;                                                        // フィードバック電圧読み出し値
int Accel = 0;                                                          // 自動運転加速時変数
int Sen1_flg = 0;                                                       // センサー1フラグ
int Sen2_flg = 0;                                                       // センサー2フラグ
int Rom_Gain = 0;                                                       // ゲイン値(EEPROM保存値)
int Rom_Gain_bak = 0;                                                   // 一回前のゲイン値(EEPROM保存値)
int Rom_Light = 0;                                                      // 常点灯値(EEPROM保存値)
int Rate_set = 5;                                                       // 加減速レート時間
int Acc_rate = 5;                                                       // 加速周期時間
int Dec_rate = 5;                                                       // 減速周期時間
int Stop_time = 5;                                                      // 停車時間(5s)
int Stop_Loop = 0;                                                      // 停車時間処理変数
int Slice_level = 736;                                                  // プッシュスイッチ、センサーのHi/Lowスライスレベル(ADCポートのため)
int Hysteresis = 20;                                                    // プッシュスイッチ、線さーのヒステリシス(0.1V)
int FB_int = 1;                                                         // フィードバック割り込みフラグ
int Gmode = 3;                                                          // ゲインモード
int Gmode_bak = 3;                                                      // 一回前のゲインモード
int Mode_set = 0;                                                       // 動作モード(0:往復モード　1:直進モード)
//char Serial_val[255];
int Serial_val;

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          SetUP INIT            \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void setup() {
    lcd.begin(16,2);                                                    // LCD表示範囲指定
    lcd.clear();                                                        // LCDクリアー
    
    Serial.begin(115200);                                               // シリアルの設定 (115200bps,8bit,None,1)
                                                                        // シリアルを有効にした場合にはLED_OrengeとLED_Blueのポートは共通の為、
                                                                        // LEDのON/OFFは無効となる

    TCCR1B &= B11111000;                                                // Timer1 Clock Chenge
    TCCR1B |= B00000100;                                                // PWM 122.5Hz
    //TCCR1B |= B00000011;                                                // PWM 490Hz
    //TCCR1B |= B00000010;                                                // PWM 3920Hz    
                                                                        // 周波数変更する場合には、割り込み内のフィードバック待ち時間を変更する必要あり
        
    pinMode(LED_Blue, OUTPUT);                                          // 各ポート設定
    pinMode(PWM_OUT1, OUTPUT);
    pinMode(PWM_OUT2, OUTPUT);
    pinMode(SW_FOR, INPUT);
    pinMode(SW_REV, INPUT);
    pinMode(INT_PWM1, INPUT_PULLUP);
    pinMode(INT_PWM2, INPUT_PULLUP);
    pinMode(LED_Orenge, OUTPUT);
    digitalWrite(LED_Orenge, LOW);
    attachInterrupt(0,int_FOR, RISING);
    attachInterrupt(1,int_REV, RISING);

    lcd.setCursor(0,0);                                                 //　オープニング画面
    lcd.print("ArduinoUNO PPack");                                      //
    lcd.setCursor(2,1);                                                 //
    lcd.print("P'sTec Rev.2.3");                                        //
  
    delay(2000);                                                        // 表示時間2s

    // '''''''''''''''''''''''''''''
    // EEPROMの保存値チェックと読み出し
    // '''''''''''''''''''''''''''''
    
    Rom_Gain = EEPROM.read(0);                                          // Gain値をEEPOMの(0)から読み出し
    if(Rom_Gain >= 10){                                                 // Gain値が11以上なら(設定させていない時の処理)
        EEPROM.write(0, 5);                                             // Gain値をEEPROMに保存(0-10)
        Rom_Gain = 5;                                                   // Gain値の変数を"5"にする
    }
    Rom_Light = EEPROM.read(1);                                         // 常点灯値をEEPROMの(1)から読み出し
    if(Rom_Light >= 255){                                               // 常点灯値が255以上なら
        EEPROM.write(1,0);                                              // 常点灯値をEEPROMに保存(0-255)
        Rom_Light = 0;                                                  // 常点灯値の変数を"0"にする
    }
    Gmode = EEPROM.read(2);                                             // ゲインモードをEEPOMの(2)から読み出し
    if(Gmode >= 10){                                                    // ゲインモードが10以上なら(設定させていない時の処理)
        EEPROM.write(2, 3);                                             // ゲインモード値をEEPROMに保存(1,3,6)
        Gmode = 3;                                                      // ゲインモードの変数を"3"にする
        }
    Rate_set = EEPROM.read(3);                                          // 加減速レートをEEPOMの(3)から読み出し
    if(Rate_set >= 21){                                                 // 加減速レートが21以上なら(設定させていない時の処理)
        EEPROM.write(3,5);                                              // 加減速レートをEEPROMに保存(0-20)
        Rate_set = 5;                                                   // 加減速レートの変数を"5"にする
    }
    Acc_rate = Rate_set;                                                // 加減速レートを加速レート変数に代入
    Dec_rate = Rate_set;                                                // 加減速レートを減速レート変数に代入
    
    Mode_set = EEPROM.read(4);                                          // 自動運転モードをEEPROMの(4)から読み出し
    if(Mode_set >= 10){                                                 // 自動運転モードが10以上なら(設定させていない時の処理)
        EEPROM.write(4,0);                                              // 自動運転モードをEEPROMに保存(0-2)
        Mode_set = 0;                                                   // 自動運転モードの変数を"0"にする
    }
    Stop_time = EEPROM.read(5);                                         // 自動運転時の停車時間をEEPROMの(5)から読み出し
    if(Stop_time >= 21){                                                // 自動運転時の停車時間が21以上なら(設定させていない時の処理)
        EEPROM.write(5,5);                                              // 自動運転時の停車時間をEEPROMに保存(0-21)
        Stop_time = 5;                                                  // 自動運転時の停車時間を"5"にする
    }

    // &&&&&&&&&&&&&&&&&&&
    //    LCDの初期表示
    // &&&&&&&&&&&&&&&&&&&
    
    lcd.clear();                                                        // LCDクリアー
    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Vol");                                                   // "Vol"LCD表示
    lcd.setCursor(9,1);                                                 // カーソルを2行目10文字目
    lcd.print("FB");                                                    // "FB"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Out");                                                   // "Out"LCD表示
    lcd.setCursor(8,0);                                                 // カーソルを1行目10文字目
    if(Gmode == 3){                                                     // ゲインモードが"3"(Normal)なら
        lcd.print(" N");                                                // "N"(Normal)を表示
    }
    else if(Gmode == 1){                                                // ゲインモードが"1"(Coreless)なら
        lcd.print(" C");                                                // "C"(Cor-Less)を表示
    }
    else if(Gmode == 6){                                                // ゲインモードが"6"(Slow)なら
        lcd.print(" S");                                                // "S"(Slow)を表示
    }
 }


// ++++++++++++++++++++++++++++++++++++++++
// +++++  Serial Command Control  +++++++++
// ++++++++++++++++++++++++++++++++++++++++
void Serial_cont(){
    int index = 0;
    int hasData = false;

    while (Serial.available() > 0 && index <= 2){
        hasData = true;
        sbuff[index] = Serial.read();
        index++;
    }
    if(hasData == true){
        switch(sbuff[0]){
            case 'V':                                                             // Volume値の受信処理
                serial_flg = 1;                                                   // シリアル受信フラグをセット
                volume_val = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30))*10;
                FB_int = 1;                                                       // Volume値受信で起動するため
                break;
            case 'D':                                                             // 進行方向の受信処理
                serial_flg = 1;                                                   // シリアル受信フラグをセット
                if(sbuff[2] - 0x30 == 0){
                  Dig = 0;
                  FB_int = 1;                                                     // 進行方向SWを倒した時に起動させるため
                }
                else if(sbuff[2] - 0x30 == 1){
                  Dig = 1;
                  FB_int = 1;                                                     // 進行方向SWを倒した時に起動させるため
                }
                else{
                  Dig = 2;                                                        // Stop受信処理
                  auto_d = 0;                                                     // auto_dフラグは"0"にする(Manualにする)
                  sen_flg = 0;                                                    // Sensor検出フラグクリアー
                  Gmode_bak = 0;                                                  
                  Rom_Gain_bak = 10;                                              
                  //serial_flg = 0;
                }
                break;
            case 'M':                                                             // Mode Set受信処理 自動運転のモードセット
                serial_flg = 1;
                Mode_set = (sbuff[2] - 0x30);
                EEPROM.write(4, Mode_set);
                break;                                                            // 現時点組み込みなし
            case 'T':                                                             // Stop Time受信処理 自動運転の停止時間セット
                serial_flg = 1;
                Stop_time = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30));
                EEPROM.write(5, Stop_time);                                       // EEPROMに保存               
                break;                                                            // 現時点組み込みなし
            case 'A':                                                             // Acc/Dec受信処理 自動運転の加速レートセット
                serial_flg = 1;
                Rate_set = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30));
                EEPROM.write(3, Rate_set);                                        // EEPROMに保存 
                break;                                                            // 現時点組み込みなし
            case 'L':                                                             // Light On Set受信処理
                serial_flg = 1;
                Rom_Light = (((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30))*10;
                EEPROM.write(1, Rom_Light);                                       // EEPROMに保存
                break;                                                            // 現時点組み込みなし
            case 'G':                                                             // Gain Set受信処理 自動運転のゲインセット  
                serial_flg = 1;
                Rom_Gain = ((sbuff[1] - 0x30) * 10) + (sbuff[2] - 0x30);
                EEPROM.write(0, Rom_Gain);
                break;                                                            // 現時点組み込みなし
            case 'F':                                                             // Gain Set受信処理 自動運転のゲインセット  
                serial_flg = 1;
                Gmode = (sbuff[2] - 0x30);
                EEPROM.write(2, Gmode);
                break;
            case 'E':                                                             // Serialコントロール終了
                serial_flg = 0;                                                   // シリアル受信フラグをリセット
                                                                                  // 方向スイッチをStopにするとシリアルフラグはリセットされる
                break;
        }
    }
}

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          MAIN LOOP             \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
void loop() {
    detachInterrupt(0);                                                 // 割り込み0停止
    detachInterrupt(1);                                                 // 割り込み1停止

    Serial_cont();                                                      // シリアル通信コントロール
    
    if(serial_flg == 0){                                                // Volumeフラグが0なら(Serial cont用)
        volume_val = analogRead(Volume);                                // Volume入力読み込み Max 1024
        volume_val = volume_val *0.8;                                   // 最大値80%とするもの
        if(volume_val >= 800){
          volume_val = 800;                                             // 上限値設定(800) 80%
        }
    }
    if(val_out <= 4 && volume_val >= 4){                                // 動作開始時にPWM起動させるため
        FB_int = 1;
    }

    //Serial.println(Gmode);                                            // Serial通信出力確認用
    //Serial.print("   ");                                              // Serial通信出力確認用
    //Serial.println(Rom_Gain);                                         // Serial通信出力確認用

    Sen1 = analogRead(Sensor_1);                                        // Sensor_1入力読み込み Max1024
    Sen2 = analogRead(Sensor_2);                                        // Sensor_2入力読み込み Max1024
  
    if( analogRead(PushSW) <= 512){                                     // PushSWが押されたら。。。
        if( digitalRead(SW_FOR) == 0){                                  // SW_FORになったいたら。。。
            Light_on_set();                                             // 常時点灯の設定へ。。。
        }
        else if( digitalRead(SW_REV) == 0){                             // SW_REVになっていたら。。。
            Gain_set();                                                 // ゲインの設定へ。。。
        }
        else if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){ // SW_STPになっていたら。。。
            AD_Rate_set();                                              // 加減速レートへ。。。
        }
    }

    if(Dig != 2){                                                       // スイッチがSTOPでなければ
        Sensor_on();                                                    // Sensor入力確認
    }
    
    attachInterrupt(0,int_FOR, RISING);                                 // FOR側フィードバック割り込み開始
    attachInterrupt(1,int_REV, RISING);                                 // REV側フィードバック割り込み開始

    //Serial.print(Sen1);                                               // Serial通信出力確認用
    //Serial.print("   ");                                              // Serial通信出力確認用
    //Serial.println(Sen2);                                             // Serial通信出力確認用
 
    // 方向SW読み込み
    if(auto_d == 0 && serial_flg == 0){                                 // auto_dフラグが0の時は。。。
        if(Dig == 2){
          FB_int = 1;
        }
        if( digitalRead(SW_FOR) == 0){ Dig = 0; }                       // SW_FORになっていたらDigは"0"にする
        if( digitalRead(SW_REV) == 0){ Dig = 1; }                       // SW_REVになっていたらDigは"1"にする
    }
    if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){          // SW_STOPになっていたらDigは"2"にする
        Dig = 2;
        auto_d = 0;                                                     // auto_dフラグは"0"にする(Manualにする)
        serial_flg = 0;
        sen_flg = 0;                                                    // Sensor検出フラグクリアー
        Gmode_bak = 0;                                                  // 一回前のGmodeを0にセット(無い値にセットし書き換えのため)
        Rom_Gain_bak = 10;                                              // 一回前のフィードバックゲイン値を10にセット(無い値にセットし書き換えのため)
    }
    FB_out();                                                           // フィードバック編集し出力

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Display LCD                  \**/\**/
 // \**/\**/  LCDの書き込みは１回で10ms程度かかるため    \**/\**/
 // \**/\**/    メインループ内では不要部分を上書き       \**/\**/
 // \**/\**/      しないよう処理しています。　　　　　　　\**/\**/
 // \**/\**/      全てを書き込みすると60ms 　　　　　　　\**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/\**/\**/

    if(volume_val / 10 != volume_val_bak / 10 || volume_val == 0){      // 一回前のVolume値と違っていたら
        lcd.setCursor(3,0);                                             // カーソルを1行目4文字目
        sprintf(buff, "%4d%%", volume_val / 10);                        // Volume値
        lcd.print(buff);                                                // 表示
        volume_val_bak = volume_val;                                    // Volume値を一回前の変数に入れる
    }
    if(val_out / 10 != val_out_bak / 10 || val_out == 0){               // 一回前の出力値と違っていたら
        lcd.setCursor(3,1);                                             // カーソルを2行目4文字目
        sprintf(buff, "%4d%%", val_out / 10);                           // PWM出力値
        lcd.print(buff);                                                // 表示
        val_out_bak = val_out;                                          // 出力値を一回前の変数に入れる
    }
    if(val_fb_chk / 10 != val_fb_chk_bak / 10 || val_fb_chk == 0){      // 一回前のフィードバック値と違っていたら
        lcd.setCursor(12,1);                                            // カーソルを2行目13文字目
        sprintf(buff, "%3d%%", val_fb_chk / 10);                        // フィードバック値
        lcd.print(buff);                                                // LCD表示
        
        sprintf(buff, "F%2d%", val_fb_chk / 10);                        // フィードバック値シリアル送信
        Serial.println(buff);                                           // fb値シリアル出力
        
        val_fb_chk_bak = val_fb_chk;                                    // フィードバック値を一回前の変数に入れる
    }
    if(auto_d == 0){                                                    // オートでなければ。。。(Auto_d = 0ならマニュアル)
        lcd.setCursor(11,0);                                            // カーソルを1行目12文字目
        if(Dig == 0){                                                   // 方向スイッチフラグがFront
            lcd.print("  FOR");                                         // LCD表示"FOR"
        }
        else if(Dig == 1){                                              // 方向スイッチフラグがReverse
            lcd.print("  REV");                                         // LCD表示"REV"
        }
        else if(Dig == 2){                                              // 方向スイッチフラグがSTOP
            lcd.print(" STOP");                                         // LCD表示"STOP"
        }
        Dig_bak = Dig;                                                  // 方向フラグを一回前の変数にいれる

        if(Gmode != Gmode_bak){                                         // ゲインモードが一回前のモードと違っていたら
            lcd.setCursor(8,0);                                         // カーソルを1行目9文字目
            if(Gmode == 3){                                             // ゲインモードが"3"(Normal)なら
                lcd.print(" N");                                        // "N"を表示
            }
            else if(Gmode == 1){                                        // ゲインモードが"1"(Coreless)なら
                lcd.print(" C");                                        // "C"を表示
            }
            else if(Gmode == 6){                                        // ゲインモードが"6"(Slow)なら
                lcd.print(" S");                                        // "S"を表示
            }
            else{                                                       // ゲインモードが上記以外なら
                sprintf(buff,"%2d",Gmode);                              // ゲインモードの倍率表示
                lcd.print(buff);                                        // Gmode値を表示
            }
            Gmode_bak = Gmode;                                          // ゲインモードを一回前の変数にいれる
        }
        if(Rom_Gain != Rom_Gain_bak){                                   // フィードバックゲインが一回前のゲインと違っていたら
            lcd.setCursor(10,0);                                        // カーソルを1行目11文字目
            lcd.print(Rom_Gain);                                        // フィードックゲイン値を表示
            Rom_Gain_bak = Rom_Gain;                                    // フィードバックゲインを一回前の変数にいれる
        }
    }
}

// \/\/\/\/\/\/\/\/\/\/\/\/\/\/
//    フィードバックデータの作成
// \/\/\/\/\/\/\/\/\/\/\/\/\/\/
void FB_out(){
    if(FB_int == 1){                                                    // 割り込み発生後の処理
        if(volume_val >= FB_Read){                                      // Volume値がFeedbak値より大きい時
            //val_fb = val_fb + 1;                                      // フィードバック累積値(val_fb)を増やして速度を上げる
            val_fb = val_fb + ((volume_val - FB_Read) / 2);            // フィードバック累積値(val_fb)を増やして速度を上げる
            if((volume_val - FB_Read / 2) == 0){
              val_fb = val_fb + 1;
            }
            if(val_fb >= 500 * (10-Rom_Gain)){                          // フィードバック積算値の最大値が500*(10-Rom_Gain)を超えたら
                val_fb = 500 * (10-Rom_Gain);                           // フィードバック積算値を500*(10-Rom_Gain)とする
            }
        }
        if(volume_val < FB_Read){                                       // Volume値がFeedbak値より小さい時
            //val_fb = val_fb - 2;                                     // フィードバック累積値(val_fb)を減らして速度を下げる
            val_fb = val_fb - ((FB_Read - volume_val) / 1);             // フィードバック累積値(val_fb)を減らして速度を下げる
            if((FB_Read - volume_val / 1) == 0){
              val_fb = val_fb - 1;
            }
            if(val_fb <= -500 * (10-Rom_Gain)){                         // フィードバック積算値の最小値が-500*(10-Rom_Gain)を下回ったら
                val_fb = -500 * (10-Rom_Gain);                          // フィードバック積算値を-500*(10-Rom_Gain)とする
            }
        }
        val_fb_chk = val_fb / (10 - Rom_Gain);                          // フィードバック積算値かフィードバックゲインを計算する

        if(Rom_Gain <= 0){                                              // フィードバックゲインが0の時には
            val_fb_chk = 0;                                             // フィードバック値をクリアする
        }
        if(volume_val <= Rom_Light){                                     // フィードバック値が常時点灯値を下回ったら。。。
            val_out = Rom_Light;                                        // 常時点灯値とする
            val_fb = 0;
            val_fb_chk = 0;
        }
        else{                                                           
            val_out = volume_val + val_fb_chk;                          // ボリューム値とフィードバック値を加算し、出力値とする
            if(val_out <= 4){
              val_out = 4;
            }
        }
        //if(volume_val <= 4){                                            // 出力値が"4"以下だったら。。。
        //    val_fb_chk = 0;                                             // フィードバック値は"0"とする
        //    val_fb = 0;                                                 // フィードバック累積値は"0"とする
            //val_out = 0;
        //}

            
    // +++++++++++++++++++++++++
    //    PWM出力
    // +++++++++++++++++++++++++
        if(Dig == 0){                                                   // Dig = 0(SW_FOR)の時は前進(PWM_OUT1)へ
            analogWrite(PWM_OUT2, 0);                                   // PWMを停止へ
            analogWrite(PWM_OUT1, val_out / 4);                         // PWMを出力する
        }
        else if(Dig == 1){                                              // Dig = 1(SW_REV)の時は後進(PWM_OUT2)へ
            analogWrite(PWM_OUT1, 0);                                   // PWMを停止へ
            analogWrite(PWM_OUT2, val_out / 4);                         // PWMを出力する
        }
        else{                                                           // Dig = 2(SW_STOP)の時は停止へ
            analogWrite(PWM_OUT1, 0);                                   // PWMを停止へ
            analogWrite(PWM_OUT2, 0);                                   // PWMを停止へ
            val_fb = 0;                                                 // フィードバック累積値(val_fb)をリセット
            val_out = 0;                                                // PWM出力データクリアー
            sen_flg == 0;                                               // どのSensorを検出したかのフラグ "0"センサー未検出
        }
        FB_int = 0;                                                     // フィードバック割り込みフラグをクリアー

        //digitalWrite(LED_Orenge,LOW);                                   // タイミング確認用(オシロで確認)
    }
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Gain Set             \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Gain_set(){                                                        // Feedback Gain設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止
    val_fb = 0;                                                         // Feedback値クリアー
    
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Gain Set (0-9)");                                        // "Gain Set"LCD表示

    Rom_Gain = EEPROM.read(0);                                          // EEPROMに保存してあるGain値を読み込み
    sprintf(buff,"Set%2d",Rom_Gain);
    lcd.setCursor(7,1);                                                 // カーソルを2行目8文字目
    lcd.print(buff);                                                    // EEPROMに保存してあったGain値をLCD表示
    if(Rom_Gain == 0){                                                  // フィードバックゲイン値が0なら
        lcd.setCursor(10,1);                                            // カーソルを2行目11文字目
        lcd.print(" N");                                                // " N"を上書き
    }
    
    while( analogRead(PushSW) <= 512){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms
    while( analogRead(PushSW) >= 512){                                  // PushSWが押下されるまでループ
                                                                        // analogRead Max1023(SW押下で"0")
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        lcd.setCursor(13,1);                                            // カーソルを1行目14文字目
        if(volume_val/113 <= 0){
            lcd.print("Non");
        }
        else{
            sprintf(buff,"%3d",volume_val/113);                         // Volume値を1/113としLCD表示用にする(max9)
            lcd.print(buff);                                            // Volume値をLCDに表示
        }
        lcd.setCursor(0,1);                                             // カーソルを2行目1文字目
        if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
            Gmode = 6;                                                  // ゲインモードを"6"とする
            lcd.print("Slow  ");                                        // "Slow"を表示(超低速走行用)
        }
        else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
            Gmode = 1;                                                  // ゲインモードを"1"とする
            lcd.print("CoLess");                                        // "CoLess"を表示(Coreless Motor)
        }
        else{
            Gmode = 3;                                                  // ゲインモードを"3"とする
            lcd.print("Normal");                                        // "Normal"を表示(通常モーター)
        }
    }                                                                 
    EEPROM.write(0, volume_val/113);                                    // Gain値をEEPROMに保存(0-10)
    Rom_Gain = volume_val/113;                                          // Gain値をRom_Gainにする
    EEPROM.write(2,Gmode);                                              // ゲインモードをEEPROMに保存(1,3,6)

    Set_return();                                                       // 設定終了処理へ
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Light On Set         \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Light_on_set(){                                                    // 常時点灯の設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止
    val_fb = 0;                                                         // Feedback値クリアー
    
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Light On Set");                                          // "Light On Set"LCD表示

    Rom_Light = EEPROM.read(1);                                         // EEPROMに保存してある常時点灯値を読み込み
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    sprintf(buff,"Set%3d%%",Rom_Light/10);                              // EEPROMに保存された常点灯値を編集
    lcd.print(buff);                                                    // 編集された常点灯値を表示
    
    while( analogRead(PushSW) <= 512){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms
    while( analogRead(PushSW) >= 512){                                  // PushSWが押下されるまでループ
                                                                        // analogRead Max1023(SW押下で"0")
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d%%",volume_val/40);                            // Volume値を1/40としLCD表示用にする(max25)
        lcd.setCursor(12,1);                                            // カーソルを1行目11文字目
        lcd.print(buff);                                                // Volume値をLCDに表示

        if(digitalRead(SW_FOR) == 0){                                   // 進行方向フラグfor"0"
            analogWrite(PWM_OUT1, volume_val/40);                       // PWM_OUT1へ出力
            analogWrite(PWM_OUT2, 0);                                   // PWM_OUT2をPWM停止
        }
        else if(digitalRead(SW_REV) == 0){                              // 進行方向フラグRev"1"
            analogWrite(PWM_OUT2, volume_val/40);                       // PWM_OUT2へ出力
            analogWrite(PWM_OUT1, 0);                                   // PWM_OUT1をPWM停止
        }
        else{                                                           // 進行方向フラグRev"2"
            analogWrite(PWM_OUT1, 0);                                   // PWM_OUT1をPWM停止
            analogWrite(PWM_OUT2, 0);                                   // PWM_OUT2をPWM停止
        }
    }
    if(volume_val >= 1000){                                             // valが1000以上なら
        volume_val = 1000;                                              // 1000にする
    }
    EEPROM.write(1, volume_val/4);                                      // 25%のボリューム値をEEPROMに保存
    Rom_Light = volume_val/4;

    Set_return();                                                       // 設定終了処理へ
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      動作モード/加減速Rate Set   \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void AD_Rate_set(){                                                     // 加減速Rateの設定
    analogWrite(PWM_OUT1, 0);                                           // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                           // PWM_OUT2停止

    val_fb = 0;                                                         // Feedback値クリアー
    
    lcd.clear();                                                        // LCDクリアー

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Mode Set");                                              // "Rate Set"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを1行目1文字目
    lcd.print("StopTime");                                              // "Stop Time"LCD表示   

    Stop_time = EEPROM.read(5);                                         // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3ds%",Stop_time);                                    // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( analogRead(PushSW) <= 512){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms
    while( analogRead(PushSW) >= 512){                                  // PushSWが押下されるまでループ
                                                                        // analogRead Max1023(SW押下で"0")
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3ds%",volume_val / 51);                          // Volume値を1/51としLCD表示用にする(max20)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示

        if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
            //Mode_set = 2;                                             // 動作モードを"2"とする
            Mode_set = 0; 
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("Option");                                        // "Option"を表示(動作モード追加部)
        }
        else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
            Mode_set = 1;                                               // ゲインモードを"1"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoStop");                                        // "GoStop"を表示(停止→発進)
        }
        else if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){
            Mode_set = 0;                                               // ゲインモードを"3"とする
            lcd.setCursor(10,0);                                        // カーソルを2行目1文字目
            lcd.print("GoTurn");                                        // "GoTurn"を表示(停止→反転発進)
        }
    }
    Stop_time = volume_val / 51;                                        // ボリューム値を停車時間変数に入れる

    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Acc / Dec        ");                                     // "Rate Set"LCD表示 
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Rate Set");                                              // "Rate Set"LCD表示 

                                                                        // 加速減速率のレート設定
    Rate_set = EEPROM.read(3);                                          // EEPROMに保存してある停車時間値を読み込み
    lcd.setCursor(8,1);                                                 // カーソルを2行目8文字目
    sprintf(buff,"%3d %",Rate_set);                                     // EEPROMに保存された加減速Rate値を編集
    lcd.print(buff);

    while( analogRead(PushSW) <= 512){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms
    while( analogRead(PushSW) >= 512){                                  // PushSWが押下されるまでループ
                                                                        // analogRead Max1023(SW押下で"0")
        volume_val = analogRead(Volume);                                // Volume値読み込み analogRead Max 1023
        sprintf(buff,"%3d %",volume_val / 51);                          // Volume値を1/51としLCD表示用にする(max20)
        lcd.setCursor(12,1);                                            // カーソルを1行目12文字目
        lcd.print(buff);                                                // Volume値をLCDに表示
    }
    Rate_set = volume_val /51;                                          // ボリューム値から加減速レートへ入れる          
                                                                    
    EEPROM.write(3, Rate_set);                                          // 加減速時間値をEEPROMに保存(0-20)
    Acc_rate = Rate_set;                                                // 加減速レートから加速レートに入れる
    Dec_rate = Rate_set;                                                // 加減速レートから減速レートに入れる
    EEPROM.write(4, Mode_set);                                          // Gain値をEEPROMに保存(0-20)
    EEPROM.write(5, Stop_time);                                         // 停車時間をEEPROMに保存(0-20s)

    Set_return();                                                       // 設定終了処理へ
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/         設定復帰準備　　　        \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
 void Set_return(){
    
    while( analogRead(PushSW) <= 512){                                  // PushSWが離されるまでループ
    }                                                                   // analogRead Max1023(SW押下で"0")
    delay(100);                                                         // Delay 100ms

    if(volume_val != 0){                                                // volume_valが0でないときは
        lcd.clear();                                                    // LCDクリアー
        lcd.setCursor(0,0);                                             // カーソルを1行目1文字目
        lcd.print("Please");                                            // "Please Volume MIN"LCD表示
        lcd.setCursor(0,1);                                             // カーソルを1行目1文字目
        lcd.print("  Minimum Volume");                                  // "Please Volume MIN"LCD表示
    }
    while(analogRead(Volume) > 0){                                      // Volumeが"0"になるまでループ
    }

    lcd.clear();                                                        // LCDクリアー
    lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
    lcd.print("Vol");                                                   // "Vol"LCD表示
    lcd.setCursor(9,1);                                                 // カーソルを1行目8文字目
    lcd.print("FB");                                                    // "FB"LCD表示
    lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
    lcd.print("Out");                                                   // "Out"LCD表示
   
    lcd.setCursor(8,0);                                                 // カーソルを1行目8文字目
    if(Gmode == 3){                                                     // ゲインモードが"3"(Normal)なら
        lcd.print(" N");                                                // "N"を表示
    }
    else if(Gmode == 1){                                                // ゲインモードが"1"(Coreless)なら
        lcd.print(" C");                                                // "C"を表示
    }
    else if(Gmode == 6){                                                // ゲインモードが"6"(Slow)なら
        lcd.print(" S");                                                // "S"を表示
    }
    else{                                                               // ゲインモードがその他なら
        lcd.print("  ");                                                // 表示をクリアー
    }
    lcd.setCursor(10,0);                                                // カーソルを1行目11文字目
    lcd.print(Rom_Gain);                                                // フィードバックゲイン値を表示
    Rom_Gain_bak = Rom_Gain;                                            // フィードバックゲインを一回前の変数に入れる

    val_out = 0;
                                                                        
    Dig_bak = 3;                                                        // 一回前の方向フラグに無い値を入れ、再表示するようにする
    volume_val_bak = -1;                                                // 一回前のボリューム値に無い値を入れ、再表示するようにする
    val_out_bak = -1;                                                   // 一回前の出力値に無い値を入れ、再表示するようにする
    val_fb_chk_bak = -1;                                                // 一回前のフィードバック値に無い値を入れ、再表示するようにする
}
    
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      Auto Drive Sensor In      \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Sensor_on(){                                                       // 往復自動運転　動作

    if(sen_flg !=1){                                                    // Sensor flgが1で無い時
                                                                        // 20200522 Hysteresis追加
        if(Sen1 >= Slice_level + Hysteresis){                           // Sensor1がHiの時 (1023 / 5V )* 716 + Hysteresis = 3.6V
            Sen1_flg = 1;                                               // Sen1_flgを1にする(Sensor1を一度読んだ事を表すフラグ)
        }
    }
    if(sen_flg !=2){                                                    // Sensor flgが2で無い時
                                                                        // 20200522 Hysteresis追加
        if(Sen2 >= Slice_level + Hysteresis){                           // Sensor2がHiの時 (1023 / 5V )* 716 + Hysteresis = 3.6V
            Sen2_flg = 1;                                               // Sen1_flgを2にする(Sensor2を一度読んだ事を表すフラグ)
        }
    }
    
    if(Sen1_flg == 1){                                                  // Sensor1のフラグがSetさせている。。。(センサーか゛Hiになった)
                                                                        // 20200522 Hysteresis追加      
        if(Sen1 <= Slice_level - Hysteresis){                           // Sensor1がLowの時 (1023 / 5V )* 716 - Hysteresis = 3.4V
            if(sen_flg != 1){                                           // Sensor flgが1で無い時
                sen_flg = 1;                                            // Sensor flgを1にする
                Auto_drv();                                             // Auto_drivを処理する
                Sen1_flg = 0;                                           // Sensor1 flgをクリアーする                                               
            }
        }
    }
    if(Sen2_flg == 1){                                                  // Sensor2のフラグがSetさせている。。。(センサーか゛Hiになった)
                                                                        // 20200522 Hysteresis追加     
        if(Sen2 <= Slice_level - Hysteresis){                           // Sensor2がLowの時 (1023 / 5V )* 716 - Hysteresis = 3.4V
            if(sen_flg != 2){                                           // Sensor flgが2で無い時
                sen_flg = 2;                                            // Sensor flgを2にする
                Auto_drv();                                             // Auto_drivを処理する
                Sen2_flg = 0;                                           // Sensor2 flgをクリアーする
            }
        }
    }
}
 // \**/\**/\*_*/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      Auto Drive                \**/\*_*/
 // \*_*/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Auto_drv(){
    lcd.setCursor(9,0);                                                 // カーソルを1行目12文字目
    lcd.print("AUTO");                                                  // LCD表示"AUTO"        
    
    auto_d = 1;                                                         // auto drive flgをsetする

    lcd.setCursor(13,0);                                                // カーソルを1行目8文字目
    if(sen_flg == 0){                                                   // センサー未検出時
        lcd.print("   ");                                               // LCD表示クリアー
        Serial.println("S11");                                          // センサー1値未検出シリアル出力
        Serial.println("S21");                                          // センサー2値未検出シリアル出力
    }
    if(sen_flg == 1){                                                   // センサー1検出時
        lcd.print(" S1");                                               // LCD表示"S1"

        Serial.println("S10");                                          // センサー1値検出シリアル出力
    }
    if(sen_flg == 2){                                                   // センサー2検出時
        lcd.print(" S2");                                               // LCD表示"S2"
        
        Serial.println("S20");                                          // センサー2値検出シリアル出力
    }

    while(val_out > Rom_Light){                                         // PWM出力値が常点灯値より大きい場合
        if(Dig == 0){                                                   // 方向フラグが"0" Forの場合
            analogWrite(PWM_OUT1,val_out/4);                            // ボリューム値の1/4をFor方向に出力(常点灯設定値は最大25%)
        }
        if(Dig == 1){                                                   // 方向フラグが"1" Revの場合
            analogWrite(PWM_OUT2,val_out/4);                            // ボリューム値の1/4をRev方向に出力(常点灯設定値は最大25%) 
        }   
      
        // 減速処理
        val_out--;                                                      // PWM出力値を-1する
        val_fb = 0;                                                     // フィードバック積算値をクリアーする
        val_fb_chk = 0;                                                 // フィードバック値をクリアーする

        lcd.setCursor(3,1);                                             // カーソルを2行目4文字目
        sprintf(buff, "%4d", val_out/10);                               // PWM出力値
        lcd.print(buff);                                                // 表示

        lcd.setCursor(11,1);                                            // カーソルを2行目12文字目
        sprintf(buff, "%4d", val_fb_chk/10);                            // フィードバック値
        lcd.print(buff);                                                // LCD表示

        delay(Dec_rate);                                                // ディレイ減速時間
    }
    Stop_Loop = Stop_time * 10;                                         // 自動運転停止時に、STOPスイッチが効くように
    while(Stop_Loop > 0){                                               // 停止時間中ならループ
        
        delay(100);                                                     // ディレイ100ms
        -- Stop_Loop;                                                   // ループ　-1

        volume_val = analogRead(Volume)/2;                              // Volume入力読み込み Max 1024　*ボリューム最大値50%に伴い変更
        lcd.setCursor(3,0);                                             // カーソルを1行目2文字目
        sprintf(buff, "%4d", volume_val/10);                            // Volume値
        lcd.print(buff);                                                // 表示

        if(digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){       // 自動運転停止中にスイッチがSTOPになったら
            Stop_Loop = 0;                                              // 停止中をクリア  
            auto_d = 0;                                                 // auto_dフラグは"0"にする(Manualにする)
        }
    }
        
    // 停車中
    if(Mode_set == 0){                                                  // 往復モード時には。。。
        Dig = !Dig;                                                     // 進行方向反転
        analogWrite(PWM_OUT1,0);                                        // 
        analogWrite(PWM_OUT2,0);                                        // 
    }
                                                                        //20200522 自動運転停止時に、STOPスイッチが効くように変更
    if(digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){           // スイッチがSTOPになっていたら以下加速処理を飛ばす
    }
    else{
        // 加速処理
        Accel = Rom_Light;                                              // 加速初期値を設定
        volume_val = analogRead(Volume)/2;                              // Volume入力読み込み Max 1024 *ボリューム最大値50%に伴い変更
        while(volume_val > Accel){                                      // ボリューム値が加速初期値より小さい時にループ
            if(Dig == 0){                                               // 方向フラグ"For"の時
                analogWrite(PWM_OUT1,Accel/4);                          // 加速初期値からボリューム値までForへPWM出力
            }
            if(Dig == 1){                                               // 方向フラグ"Rev"の時
                analogWrite(PWM_OUT2,Accel/4);                          // 加速初期値からボリューム値までRevへPWM出力
            }   
            Accel++;                                                    // 出力値を加算していく
            val_out = Accel;                                            // PWM出力値を+1する

            lcd.setCursor(3,1);                                         // カーソルを2行目4文字目
            sprintf(buff, "%4d", val_out/10);                           // PWM出力値を編集
            lcd.print(buff);                                            // 表示

            lcd.setCursor(11,1);                                        // カーソルを2行目12文字目
            sprintf(buff, "%4d", val_fb_chk/10);                        // フィードバック値を編集
            lcd.print(buff);                                            // LCD表示
       
            delay(Acc_rate);                                            // ディレイ加速時間
        }
    }
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/         Feedback Input         \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void int_FOR(){                                                         // For側の割り込み
    detachInterrupt(0);                                                 // 割り込み0停止
    
    GainN = volume_val / 64;                                             // ゲインはボリューム値の1/64とする(ループ回数)
    if(GainN <= 4){                                                     // 割り込み毎のフィードバック電圧読み取り
        GainN = 4;
    }
    
    if(n >= GainN){                                                     // GainNがN回になったら以下FeedBack電圧の取り込み処理を行う
        digitalWrite(LED_Orenge,HIGH);                                  // ★タイミング確認用(オシロで確認)
        delayMicroseconds(7000);                                        // ディレイ7000us(PWMの立ち上がりから7000us待つてFB電圧取り込み)
        FB_Read = analogRead(PWM_FB1);                                  // フィードバック電圧取り込み
        FB_Read = FB_Read * Gmode;                                      // 取り込んだ値にGAINモードを掛ける(1=Cor-Less 3=Normal 6=Slow)
      
        digitalWrite(LED_Orenge,LOW);                                   // ★タイミング確認用(オシロで確認)
        n = 0;                                                          // nをクリアー
        FB_int = 1;                                                     // フィードバック割り込みフラグをセット
    }
    n++;                                                                // n+1
    attachInterrupt(0,int_FOR, RISING);                                 // FOR側フィードバック割り込み開始
}

void int_REV(){                                                         // Rev側の割り込み
    detachInterrupt(1);                                                 // 割り込み1停止
    
    GainN = volume_val / 64;                                             // ゲインはボリューム値の1/64とする(ループ回数)
    if(GainN <= 4){                                                     // 割り込み毎のフィードバック電圧読み取り
        GainN = 4;
    }
    
    if(n >= GainN){                                                     // GainNがN回になったら以下FeedBack電圧の取り込み処理を行う
        digitalWrite(LED_Orenge,HIGH);                                  // ★タイミング確認用(オシロで確認)
        delayMicroseconds(7000);                                        // ディレイ7000us(PWMの立ち上がりから7000us待つてFB電圧取り込み)
        FB_Read = analogRead(PWM_FB2);                                  // フィードバック電圧取り込み
        FB_Read = FB_Read * Gmode;                                      // 取り込んだ値にGAINモードを掛ける(1=Cor-Less 3=Normal 6=Slow)

        digitalWrite(LED_Orenge,LOW);                                   // ★タイミング確認用(オシロで確認)
        n = 0;                                                          // nをクリアー
        FB_int = 1;                                                     // フィードバック割り込みフラグをセット
    }
    n++;                                                                // n+1
    attachInterrupt(1,int_REV, RISING);                                 // FOR側フィードバック割り込み開始
}
