﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApp1
{
    public partial class WindowsArduinoPowerPack : Form
    {
        public WindowsArduinoPowerPack()
        {
            InitializeComponent();
        }

        private void Button_up_Click(object sender, EventArgs e)
        {
            if (NumericUpDown.Value <= 98)
            {
                NumericUpDown.Value++;
            }
        }

        private void Button_down_Click(object sender, EventArgs e)
        {
            if (NumericUpDown.Value >= 1)
            {
                NumericUpDown.Value--;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

            string[] ports1 = System.IO.Ports.SerialPort.GetPortNames();
            foreach (string port1 in ports1)
            {
                comboBox1.Items.Add(port1);
            }
            if (comboBox1.Items.Count > 0)
                comboBox1.SelectedIndex = 0;
        }

        private void Form1_Closed(object sender, EventArgs e)
        {
            SerialPort1.Close();
            serialPort2.Close();
        }

        private void NumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("V" + $"{NumericUpDown.Value:00}");
            SerialPort1.Write(vbuff);

            if(NumericUpDown.Value <= NumericUpDown_L.Value)
            {
                NumericUpDown.Value = NumericUpDown_L.Value;
            }
            TrackBar_Speed.Value = (int)NumericUpDown.Value;

            //if (numericUpDown1.Value <= 9)
            //{
            //    serialPort1.Write("V0" + numericUpDown1.Value);

            //}
            //else
            //{
            //    serialPort1.Write("V" + numericUpDown1.Value);
            //}
        }

        private void Button_S1_Open_Click(object sender, EventArgs e)
        {
            if (Button_S1_Open.Text == "OPEN")
            {
                SerialPort1.BaudRate = 115200;
                SerialPort1.Parity = System.IO.Ports.Parity.None;
                SerialPort1.DataBits = 8;
                SerialPort1.StopBits = System.IO.Ports.StopBits.One;
                //serialPort1.Handshake = 0;
                //SerialPort1.PortName = textBox1.Text;
                SerialPort1.PortName = this.comboBox1.SelectedItem.ToString();
                SerialPort1.Open();
                Button_S1_Open.Text = "CLOSE";
                comboBox1.Enabled = false;
                NumericUpDown.Value = 0;
                SerialPort1.Write("V00");
                RadioButton_Stop.Checked = true;
                SerialPort1.Write("D02");
                RadioButton_For.Enabled = true;
                RadioButton_Rev.Enabled = true;
                RadioButton_Stop.Enabled = true;
                TrackBar_L.Enabled = true;
                NumericUpDown_L.Enabled = true;
                NumericUpDown_L.Value = 0;
                gain設定ToolStripMenuItem.Enabled = true;
                fB倍率ToolStripMenuItem.Enabled = true;
                自動運転ToolStripMenuItem.Enabled = true;
                Timer1.Enabled = true;
                //TrackBar_Speed.Enabled = true;
                toolStripStatusLabel1.Text = "リモート中はPowerPackボードの進行方向スイッチをFOR又はREVにして下さい。";
                //statusStrip1.Text = "リモート中はPowerPackボードの進行方向スイッチをFOR又はREVにして下さい。";
            }
            else
            {
                RadioButton_Stop.Checked = true;
                SerialPort1.Write("D02");
                NumericUpDown.Value = 0;
                NumericUpDown_L.Value = 0;
                SerialPort1.Write("E00");               // Sirial Controll END
                SerialPort1.Close();
                Button_S1_Open.Text = "OPEN";
                comboBox1.Enabled = true;
                RadioButton_For.Enabled = false;
                RadioButton_Rev.Enabled = false;
                RadioButton_Stop.Enabled = false;
                Timer1.Enabled = false;
                TrackBar_Speed.Enabled = false;
                TrackBar_L.Enabled = false;
                NumericUpDown_L.Enabled = false;
                gain設定ToolStripMenuItem.Enabled = false;
                fB倍率ToolStripMenuItem.Enabled = false;
                自動運転ToolStripMenuItem.Enabled = false;
                toolStripStatusLabel1.Text = " ";
            }

        }

        private void RadioButton_For_CheckedChanged(object sender, EventArgs e)
        {
            SerialPort1.Write("D00");
            NumericUpDown.Enabled = true;
            Button_up.Enabled = true;
            Button_down.Enabled = true;
            RadioButton_Rev.Enabled = false;
            TrackBar_Speed.Enabled = true;
            TrackBar_L.Enabled = false;
            NumericUpDown_L.Enabled = false;
            gain設定ToolStripMenuItem.Enabled = false;
            fB倍率ToolStripMenuItem.Enabled = false;
            自動運転ToolStripMenuItem.Enabled = false;
            NumericUpDown.Value = NumericUpDown_L.Value;
            TrackBar_Speed.Value = (int)NumericUpDown_L.Value;

            //NumericUpDown.Value = NumericUpDown_L.Value;
        }

        private void RadioButton_Rev_CheckedChanged(object sender, EventArgs e)
        {
            SerialPort1.Write("D01");
            NumericUpDown.Enabled = true;
            Button_up.Enabled = true;
            Button_down.Enabled = true;
            RadioButton_For.Enabled = false;
            TrackBar_Speed.Enabled = true;
            TrackBar_L.Enabled = false;
            gain設定ToolStripMenuItem.Enabled = false;
            fB倍率ToolStripMenuItem.Enabled = false;
            自動運転ToolStripMenuItem.Enabled = false;
            NumericUpDown_L.Enabled = false;
            NumericUpDown.Value = NumericUpDown_L.Value;
            TrackBar_Speed.Value = (int)NumericUpDown_L.Value;

            //NumericUpDown.Value = NumericUpDown_L.Value;
        }

        private void RadioButton_Stop_CheckedChanged(object sender, EventArgs e)
        {
            SerialPort1.Write("D02");
            NumericUpDown.Value = 0;
            textBox_Feedback.Text = "0";
            textBox_Out.Text = "0";
            NumericUpDown.Value = 0;
            TrackBar_Speed.Value = 0;
            NumericUpDown.Enabled = false;
            Button_up.Enabled = false;
            Button_down.Enabled = false;
            SerialPort1.Write("V00");
            RadioButton_For.Enabled = true;
            RadioButton_Rev.Enabled = true;
            TrackBar_Speed.Enabled = false;
            TrackBar_L.Enabled = true;
            NumericUpDown_L.Enabled = true;
            gain設定ToolStripMenuItem.Enabled = true;
            fB倍率ToolStripMenuItem.Enabled = true;
            自動運転ToolStripMenuItem.Enabled = true;
        }

        private void Timer1_Tick(object sender, EventArgs e)
        {
            //! シリアルポートをオープンしていない場合、処理を行わない.
            if (SerialPort1.IsOpen == false)
            {
                return;
            }
            try
            {
                char[] spt = { '\r','\n' };
                string srdata = SerialPort1.ReadExisting();
                string[] data = srdata.Split(spt);

                int posi = data[0].IndexOf("F");
                if (posi == 0)
                {
                    string in_data = data[0].Remove(0, 1);
                    textBox_Feedback.Text = in_data;
                    int in_data1 = int.Parse(in_data);
                    int in_data2 = int.Parse(NumericUpDown.Text);
                    int in_data3 = in_data2 + in_data1;
                    //int in_data4 = int.Parse(NumericUpDown_L.Text);
                    //int in_data5 = in_data3 + in_data4;
                    string in_data6 = in_data3.ToString();
                    textBox_Out.Text = in_data6;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void TrackBar_Speed_Scroll(object sender, EventArgs e)
        {
            NumericUpDown.Value = TrackBar_Speed.Value;
        }

        private void ToolStripMenuItem2_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G00");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem3_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G01");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem4_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G02");
            SerialPort1.Write(vbuff);
        }
        
        private void ToolStripMenuItem5_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G03");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem6_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G04");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem7_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G05");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem8_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G06");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem9_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G07");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem10_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G08");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem11_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("G09");
            SerialPort1.Write(vbuff);
        }

        private void TrackBar_L_Scroll(object sender, EventArgs e)
        {
            NumericUpDown_L.Value = TrackBar_L.Value;
        }

        private void NumericUpDown_L_ValueChanged(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("L" + $"{NumericUpDown_L.Value:00}");
            SerialPort1.Write(vbuff);
            TrackBar_L.Value = (int)NumericUpDown_L.Value;
            TrackBar_Speed.Value = (int)NumericUpDown_L.Value;
            NumericUpDown.Value = (int)NumericUpDown_L.Value;
        }

        private void GoTurnToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("M02");
            SerialPort1.Write(vbuff);
        }

        private void GoStopToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("M01");
            SerialPort1.Write(vbuff);
        }
        private void ToolStripMenuItem22_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("T00");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem23_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("T05");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem24_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("T10");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem25_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("T15");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem26_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("T20");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem17_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("A00");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem18_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("A05");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem19_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("A10");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem20_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("A15");
            SerialPort1.Write(vbuff);
        }

        private void ToolStripMenuItem21_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("A20");
            SerialPort1.Write(vbuff);
        }

        private void X1ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("F01");
            SerialPort1.Write(vbuff);
        }

        private void X3ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("F03");
            SerialPort1.Write(vbuff);
        }

        private void X6ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string vbuff;
            vbuff = String.Format("F06");
            SerialPort1.Write(vbuff);
        }
        /*
private void SerialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
{
//! シリアルポートをオープンしていない場合、処理を行わない.
if (SerialPort1.IsOpen == false)
{
return;
}

try
{
//! 受信データを読み込む.
string buff = SerialPort1.ReadLine();
//string data = serialPort1.ReadExisting();

//! 受信したデータをテキストボックスに書き込む.
textBox_Feedback.Text =  buff;
//Invoke(new Delegate_RcvDataToTextBox( textBox2 ), new Object[] { data });
}
catch (Exception ex)
{
MessageBox.Show(ex.Message);
}
}*/
    }
}