// CONFIG1
#pragma config FEXTOSC = OFF        // FEXTOSC External Oscillator mode Selection bits (Oscillator not enabled)
#pragma config RSTOSC = HFINT32     // Power-up default value for COSC bits (HFINTOSC with 2x PLL (32MHz))
#pragma config CLKOUTEN = OFF       // Clock Out Enable bit (CLKOUT function is disabled; I/O or oscillator function on OSC2)
#pragma config CSWEN = ON           // Clock Switch Enable bit (Writing to NOSC and NDIV is allowed)
#pragma config FCMEN = ON           // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config MCLRE = OFF           // Master Clear Enable bit (MCLR/VPP pin function is MCLR; Weak pull-up enabled)
#pragma config PWRTE = ON           // Power-up Timer Enable bit (PWRT disabled)
#pragma config WDTE = OFF           // Watchdog Timer Enable bits (WDT disabled; SWDTEN is ignored)
#pragma config LPBOREN = OFF        // Low-power BOR enable bit (ULPBOR disabled)
#pragma config BOREN = ON           // Brown-out Reset Enable bits (Brown-out Reset enabled, SBOREN bit ignored)
//#pragma config BORV = LOW           // Brown-out Reset Voltage selection bit (Brown-out voltage (Vbor) set to 2.45V)
#pragma config PPS1WAY = ON         // PPSLOCK bit One-Way Set Enable bit (The PPSLOCK bit can be cleared and set only once; PPS registers remain locked after one clear/set cycle)
#pragma config STVREN = ON          // Stack Overflow/Underflow Reset Enable bit (Stack Overflow or Underflow will cause a Reset)
#pragma config DEBUG = OFF          // Debugger enable bit (Background debugger disabled)

// CONFIG3
#pragma config WRT = OFF            // User NVM self-write protection bits (Write protection off)
#pragma config LVP = OFF             // Low Voltage Programming Enable bit (Low Voltage programming enabled. MCLR/VPP pin function is MCLR. MCLRE configuration bit is ignored.)

// CONFIG4
#pragma config CP = OFF             // User NVM Program Memory Code Protection bit (User NVM code protection disabled)
#pragma config CPD = OFF            // Data NVM Memory Code Protection bit (Data NVM code protection disabled)

// MCLRRE3̎g
// MCLREEEMCLRE/ON   LVP/ON
// RA3 EEEMCLRE/OFF  LVP/OFF
// Power PackłRE3ƂLEDgp邽߁AMCLRELVP͋OFFɂ܂

#include <stdio.h>
#include <stdlib.h>
#include <xc.h>
#include "pic16F18855.h"
#include "Char_LCD.h"

// NbNgw
// (__delay_ms()֐KvƂĂ邽)
#define _XTAL_FREQ  32000000

//#define PushSW          RA4                   // ?Rev2.0
#define LED_Blue        RA4                     // Rev3.0?
#define Volume          RA5
#define Sensor_in1      RA6                     // Analog
#define Sensor_in2      RA7                     // Analog

#define Point2_out      RB0
#define Point1_out      RB1
#define FeedBack_in2    RB2                     // Analog
#define FeedBack_in1    RB3                     // Analog
#define For_SW          RB4
#define Rev_SW          RB5
#define LED_Orenge      RB6
#define LED_Green       RB7

#define LCD_BACK_Light  RC0
#define PWM2_Out        RC1
#define PWM1_Out        RC2
#define PointSW1        RC6
#define PointSW2        RC7
#define PushSW          RE3                     // Rev3.0? (?Rev2.0͖gp)

typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
typedef signed   char   int8;
typedef signed   short  int16;
typedef signed   long   int32;
typedef          float  float32;

#define PWM_DELEY_TIME   3500                                          // PWMdeleyԁB3ms (4ms 250Hz)
//#define Dec_rate  10
//#define Acc_rate  10
//#define Stop_time 3;                                                    // Stop Time 3s

int8   Acc_rate = 10;
int8   Dec_rate = 10;
int8   Rate_Set = 10;
int16  Stop_time = 3;
int16  Stop_time_set = 3;
uint8  CW_CCW = 0;
uint8  Manu_Auto = 0;
int16  Speed = 0;
int16  StopSpeed = 0;
uint8  DriveL = 0;
uint8  DriveH = 250;
int16  FB_val = 0;
int16  ADC_FB_val = 0;
int16  ADC_VR2_in = 0;
uint8  ADC_GAIN_in = 0;                                             // FeedbackGAINl
uint8  ADC_GAIN_set = 8;                                            // FeedbackGAINݒl
uint8  LIGHT_ON_in = 0;                                             // LIGHT_ON̏l
uint8  LIGHT_ON_set = 0;                                            // LIGHT_ONݒl
uint8  AutoMode_in = 0;
uint8  AutoMode_set = 0;
int8  Through = 0;
int8  Through_set;
uint16  Sen1_in = 255;
uint16  Sen2_in = 255;
uint8   Hysteresis = 15;                                             // 0.01953125V * 15 =0.29296875V
uint8   Sen1_Dig = 1;
uint8   Sen2_Dig = 1;
uint8	sen_flg = 0;
uint8   Sen1_flg = 0;
uint8   Sen2_flg = 0;
uint16  Slice_level = 205;                                           // ZT[Hi/LowXCXx 80%
uint8   Accel = 0;
char    buff[256];                                                  // obt@
int16   FB_chk_val = 0;
uint8   Sen2_in_min = 255 ;
uint8  i = 0;
char   auto_drive_mode = 0;                                         // 0=ȉ~2w[h/1=P[h
uint8  after_int = 0;
int16  GainN = 10;
uint8  Gmode = 3;
uint8  Flag_PushSW1 = 0;
uint8  Flag_PushSW2 = 0;
uint8  Flag_PushSW3 = 0;
uint16 time_dely = 0;
uint8 skip_flg = 1;

__EEPROM_DATA (0x05, 0x00, 0x03, 0x00, 0x05, 0x0A, 0x00, 0x00);     // EEPROM̏lB8oCgPʂŏ邱ƁB
                                                                    // 1ByteڂDownloadGAINl(08)
// Function
void FB_input(void);
void ADC_input(void);                                              // ACDϊ͏
void go_wait(void);                                                // GOω҂
void go_wait_interrupt(void);                                      // GOω҂(荞ݏp)
void GAIN_set(void);                                               // Feedback Gainݒ菈
void L_on_set(void);
void PWM_out(void);                                                // PWMo
void AUTO_Mode(void);
void Auto_drv(void);
void Sensor_on(void);
void Auto_Mode_Set(void);

// ******************************
// 荞ݏ@(̊荞ݓŊ|ZAZgpƃ[jOł)
// ******************************
void __interrupt() isr(void)
{
    //INTCONbits.GIE = 0;                                         //S荞ݒ~
    //Timer1̊荞݂Ȃ(10ms)
    if (TMR1IF == 1) {

        PIR4bits.TMR1IF = 0;                                        // ^C}1݃tONA
                
        TMR1H = 0xD8;                                               // ^C}[P̍Đݒi65536-10000=55536)=1ms
        TMR1L = 0xF0;
        //TMR1IF = 0;
        PIR4bits.TMR1IF = 0;                                        // ^C}1݃tONA
        
        if(time_dely == 0){
            skip_flg = 0;                                           // ZT[ǂݍ݃tO@ǂݍ
            LED_Green = 0;                                          // GreenLED_
        }
        else{
            skip_flg = 1;                                           // ZT[ǂݍ݃tO@XLbv
            LED_Green = 1;                                          // GreenLED
            if(time_dely > 0){
                time_dely--;
            }
        }
    }

    //Timer2̊荞݂Ȃ(8ms)
    else if (TMR2IF == 1) { 
        //TMR2IF = 0;
        PIR4bits.TMR2IF = 0;                                        // ^C}2݃tONA
        
                                                                    // t[hobNd̎荞ݎ
        if(GainN >= ADC_VR2_in){                                    // xオ閈ɃtB[hobN荞ݎr
            LED_Orenge = 0;                                         // ^C~OmFp check check check check check
            FB_input();                                             // FeedBackd̎荞
            after_int = 1;                                          // INT Flug
            GainN = 10;
        }
        GainN = GainN + 4;                                          // Zlɂ{[lɈˑ荞ݎ𒲐
    }
    //INTCONbits.GIE = 1;                                             //S荞݋
}

// ******************************
//  ADCtOGOω҂(荞ݏp)
// ******************************
void go_wait_interrupt(void){
    __delay_us(10);                                                 // 10us Delay@(ANCW^C)
    ADGO = 1;                                                       // ADCϊStart
    while( ADGO );                                                  // ADCϊI܂őҋ@
}

// ******************************
//  ADCtOGOω҂
// ******************************
void go_wait(void){
    __delay_us(10);                                                 // 10us Delay@(ANCW^C)
    ADGO = 1;                                                       // ADCϊStart
    while( ADGO );                                                  // ADCϊI܂őҋ@
}

// ******************************
// ADC FBǂݍݏ(Timer2 int)@(̊荞ݓŊ|ZAZgpƃ[jOł)
// ******************************
void FB_input(void){ 
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    // FEED BACKǂݎ^C~O҂
    //    PWM̗肩1500us҂Feedbackd荞ނƂŋNd𑪒肷
    // +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    __delay_us(PWM_DELEY_TIME);                                     // PWMオ肩Delay@(4m3.5msŐݒ蒆)

    // ++++++++++++++++++++++
    // Feedbackd̎荞
    // ++++++++++++++++++++++
    
    // isɂAD̎荞݃|[gςĂ
    if (CW_CCW == 1) {
        ADPCH = 0b00001011;                                         // ANB3 Port Set ADC_FB_val
        ADCON0 = 0b10000000;                                        // ANB3ADCϊɐݒ
        go_wait_interrupt();                                        // GOω҂(荞ݏp)
        ADC_FB_val = ADRESH;                                        // Feedback̒l荞
    }
    else if (CW_CCW == 0) {
        ADPCH = 0b00001010;                                         // ANB2 Port Set ADC_FB_val
        ADCON0 = 0b10000000;                                        // ANB2ADCϊɐݒ
        go_wait_interrupt();                                        // GOω҂(荞ݏp)
        ADC_FB_val = ADRESH;                                        // Feedback̒l荞
    }
    if (ADC_FB_val >= 255) {                                        // PR2̍ől𒴂Ă
        ADC_FB_val = 255;                                           // PR2̍őlɂ
    }
    ADC_FB_val = ADC_FB_val;                                        // 荞񂾒lGAIN[h|
                                                                    // 荞ݓGmode|ƃ[jOôŁACŏs
    
    LED_Orenge = 1;                                                 // ^C~OmFp
}
  
// ******************************
// ADCǂݍݏ
// ******************************
void ADC_input(void){  
    // +++++++++++++++++++++++
    // x{[l荞
    // +++++++++++++++++++++++
    ADPCH = 0b00000101;                                             // ANA5 Port Set ADC_VR2_in
    ADCON0 = 0b10000000;                                            // ADC Enable ; Left-justified
    go_wait();                                                      // GOω҂
    ADC_VR2_in = ADRESH;                                            // x{[̒lVR2_in(8bit荞)
    
    // ++++++++++++++++++++++++++    
    // ʒuZT[l̓ǂݎ(1)
    // ++++++++++++++++++++++++++
    ADPCH = 0b00000110;                                             // ANA6 Port Set ADC_Sen1_in    
    ADCON0 = 0b10000000;                                            // ANA6ADCϊɐݒ
    go_wait();                                                      // GOω҂
    Sen1_in = ADRESH;                                               // ZT[(1)̒lSen1_in
    
    // ++++++++++++++++++++++++++
    // ʒuZT[l̓ǂݎ(2)
    // ++++++++++++++++++++++++++
    ADPCH = 0b00000111;                                             // ANA7 Port Set ADC_Sen2_in 
    ADCON0 = 0b10000000;                                            // ANA7ADCϊɐݒ
    go_wait();                                                      // GOω҂
    Sen2_in = ADRESH;                                               // ZT[(2)̒lSen2_in
    
    // +++++++++++++++++++++++
    // ʒuZT[LED\
    // +++++++++++++++++++++++
    if (Sen1_in <= Slice_level || Sen2_in <= Slice_level) {         // ZT[oxȂ
        LED_Blue = 0;                                               // Blue LED_
    }
    else {
        LED_Blue = 1;                                               // Blue LED
    } 
} 
   
// ******************************
// GAINݒ
// ******************************
void GAIN_set(void) {
    if( PushSW == 0 && Rev_SW == 0){                                // PUSHXCb`Ăԑ҂
        Flag_PushSW1 = 1;                                           // PUSHXCb`ꂽtO𗧂Ă
    }
    else{
        if(Flag_PushSW1 == 1){                                      // PUSHXCb`
            INTCONbits.GIE = 0;                                     // S荞݋֎~
            __delay_ms(100);                                        // 100msҋ@
            Flag_PushSW1 = 0;                                       // PUSHXCb`ĂtO̓NA[
            __delay_ms(10);                                         // 10msҋ@
            LCD_Clear();                                            // LCD\NA[
    
            while(PushSW == 1){                                     // PUSHXCb`܂ő҂GAINݒ
                ADC_input();                                        // ADCǂݍ
                ADC_GAIN_in = ADC_VR2_in / 26;                      // {[l1/26ɂlADC_GAIN_inɓ(ől9)
        
                LCD_Char_Position(0u,0u);                           // Gainݒʕ\
                LCD_Char_PrintString("FB Gain");                    //
        
                sprintf(buff,"Set%3d", ADC_GAIN_set);               // LCDGAINݒl\
                LCD_Char_Position(1u,0u);                           //
                LCD_Char_PrintString(buff);                         //
                
                sprintf(buff,"Gain%3d ", ADC_GAIN_in);              // LCDحђl0\
                LCD_Char_Position(1u,9u);                           //
                LCD_Char_PrintString(buff);                         //
        
                if(For_SW == 0){                                    // Gain Mode̐ݒ(荞񂾃tB[hobNd̔{)
                    LCD_Char_Position(0u,10);                       //
                    LCD_Char_PrintString("Slow  ");                 // SlowGmode x6(ᑬ^])
                    Gmode = 6;                                      //
                }
                else if(Rev_SW == 0){                               //
                    LCD_Char_Position(0u,10);                       //
                    LCD_Char_PrintString("Core-L");                 // Core-LGmode x1(RAX[^[HOQ[W)
                    Gmode = 1;                                      //
                }
                else{
                    LCD_Char_Position(0u,10);                       // 
                    LCD_Char_PrintString("Normal");                 // NolmalGmode x3(NQ[W̒ʏ탂[^[)
                    Gmode = 3;                                      //
                }
                __delay_ms(10);                                     // 10msҋ@
            }
            while(PushSW == 0){                                     // PushXCb`Ăԃ[v
            }
            
            __delay_ms(10);                                         // 10msҋ@
            ADC_GAIN_set = ADC_GAIN_in;                             // Gainݒl
            // EEPROݍ
            eeprom_write(0, ADC_GAIN_set);                          // GainEEPROMɏ
            eeprom_write(2,Gmode);                                  // Gain ModeEEPROMɏ
    
            LCD_Clear();                                            // LCD\NA[
        
            LCD_Char_Position(0u,0u);                               //
            LCD_Char_PrintString("Please");                         // {[Minimumɂ悤\
            LCD_Char_Position(1u,2u);                               //
            LCD_Char_PrintString("Minimum Volume");                 //
        
            while(ADC_VR2_in >= 4){                                 // {[MinimumɂȂ܂Ń[v
                ADC_input();                                        // ADCǂݍ
                __delay_ms(10);                                     // 10msҋ@
            }
            while(PushSW == 0){                                     //  PushXCb`Ăԃ[v
            }
            LCD_Clear();                                            // LCD\NA[
            __delay_ms(10);                                         // 10msҋ@
            INTCONbits.GIE = 1;                                     //S荞݋
        }
    }
}
// ******************************
//  펞_ݒ
// ******************************
void L_on_set(void) {
    if( PushSW == 0 && For_SW == 0){                                // PUSHXCb`Ăԑ҂
        Flag_PushSW2 = 1;                                           // PUSHXCb`ꂽtO𗧂Ă
    }
    else{
        if(Flag_PushSW2 == 1){
            INTCONbits.GIE = 0;                                     // S荞݋֎~
            __delay_ms(100);                                        // 100msҋ@
            Flag_PushSW2 = 0;                                       // Flag_PushSW2tONA[
            __delay_ms(10);                                         // 10msҋ@
            LCD_Clear();                                            // LCD\NA[
    
            while( PushSW == 1 ){                                   // PUSHXCb`܂ő҂ď펞_ݒ
                ADC_input();                                        // ADCǂݍ
                LIGHT_ON_in = ADC_VR2_in / 10;                      // {[l1/10ɂlLIGHT_ON_inɓ(ől25)
        
                Speed = LIGHT_ON_in;                                // 펞_lPWMl
                PWM_out();                                          // PWMo
        
                LCD_Char_Position(0u,0u);                           // 펞_ݒ\LCDo    
                LCD_Char_PrintString("LIGHT ON Set");               //
        
                sprintf(buff,"Set%3d%% ", LIGHT_ON_set);            // LCDɏ펞_ݒۑl\
                LCD_Char_Position(1u,0u);                           //
                LCD_Char_PrintString(buff);                         //
                
                sprintf(buff,"  LIGHT%3d%% ", LIGHT_ON_in);         // LCDحђl\
                LCD_Char_Position(1u,6u);                           //
                LCD_Char_PrintString(buff);                         //
        
                __delay_ms(10);                                     // 10msҋ@
            }
            while(PushSW == 0){                                     // PushXCb`Ăԃ[v                             
            }                                                       //
            __delay_ms(10);                                         // 10msҋ@
    
            LIGHT_ON_set = LIGHT_ON_in;                             // 펞_ݒl
            // EEPROݍ
            eeprom_write(1, LIGHT_ON_set);                          // 펞_ۑlEEPROMɏ                       
    
            LCD_Clear();                                            // LCD\NA[
            LCD_Char_Position(0u,0u);                               //
            LCD_Char_PrintString("Please");                         // {[Minimumɂ悤\
            LCD_Char_Position(1u,2u);                               //
            LCD_Char_PrintString("Minimum Volume");                 //
        
            while(ADC_VR2_in >= 4){                                 // {[MinimumɂȂ܂Ń[v
                ADC_input();                                        // ADCǂݍ
                __delay_ms(10);                                     // 10msҋ@
            }
            while(PushSW == 0){                                     //  PushXCb`Ăԃ[v
            }
            
            LCD_Clear();                                            // LCD\NA[
            __delay_ms(10);                                         // 10msҋ@
            INTCONbits.GIE = 1;                                     //S荞݋
        }
    }
}
// ******************************
//  Auto Modeݒ
// ******************************
void Auto_Mode_Set(void) {
    if( PushSW == 0 && For_SW == 1 && Rev_SW == 1){                 // PUSHXCb`Ăԑ҂
        Flag_PushSW3 = 1;                                           // PUSHXCb`ꂽtO𗧂Ă
    }
    else{
        if(Flag_PushSW3 == 1){                                      // PUSHXCb`ꂽtOĂ
            INTCONbits.GIE = 0;                                     // S荞݋֎~
            __delay_ms(100);                                        // 100msҋ@
            Flag_PushSW3 = 0;                                       // Flag_PushSW3tONA[
            __delay_ms(10);                                         // 10msҋ@
            LCD_Clear();                                            // LCD\NA[
    
            while( PushSW == 1 ){                                   // PUSHXCb`܂ő҂Ď[hݒ
                ADC_input();                                        // ADCǂݍ
                Stop_time = ADC_VR2_in / 4;                         // {[l1/4ɂlLIGHT_ON_inɓ(ől64)
                if(Stop_time >= 60){                                // Stop_time60sȏȂ
                    Stop_time = 60;                                 // 60sɂ
                }
       
                LCD_Char_Position(0u,0u);                           //
                LCD_Char_PrintString("Mode Set");                   // ^]샂[hݒ\LCDo
                LCD_Char_Position(1u,0u);                           //
                LCD_Char_PrintString("StopTime");                   // Ԏ

                sprintf(buff,"%3ds%",Stop_time_set);                // Ԏԕۑl\
                LCD_Char_Position(1u,8u);                           //
                LCD_Char_PrintString(buff);                         //
                
                sprintf(buff,"%3ds", Stop_time);                    // Ԏԃ{[l\
                LCD_Char_Position(1,12);                            //
                LCD_Char_PrintString(buff);                         //
                                        
                if(For_SW == 0){                                    // gOXCb`ForȂ
                    AutoMode_set = 2;                               // AutoMode_set 2 
                    LCD_Char_Position(0u,10u);                      //
                    LCD_Char_PrintString("Option");                 // OptionLCDɕ\
                }
                else if(Rev_SW == 0){                               // gOXCb`RevȂ
                    AutoMode_set = 1;                               // AutoMode_set 1 
                    LCD_Char_Position(0u,10u);                      //
                    LCD_Char_PrintString("GoStop");                 // GoStopLCDɕ\
                }
                else if(For_SW == 1 && Rev_SW == 1){                // gOXCb`ʒuȂ
                    AutoMode_set = 0;                               // AutoMode_set 0 
                    LCD_Char_Position(0u,10u);                      //
                    LCD_Char_PrintString("GoTurn");                 // GoTurnLCDɕ\
                }
                
                __delay_ms(100);                                    // 100msҋ@
            }
            while(PushSW == 0){                                     //  PushXCb`Ăԃ[v
            }
            __delay_ms(100);                                        // 100msҋ@
            
            LCD_Char_Position(0u,0u);                               // ̐ݒ
            LCD_Char_PrintString("Acc/DecRate");                    // [gݒ
            LCD_Char_Position(1u,0u);                               //
            LCD_Char_PrintString("Through Time  ");                  // ZT[ʉ߉񐔐ݒ
            
            LCD_Char_Position(0,11);                                //
            sprintf(buff,"%2d %", Rate_Set);                        // [g̕ۑl\
            LCD_Char_PrintString(buff);                             //
            
            while(PushSW == 1){                                     // PushXCb`Ăԑ҂
                ADC_input();                                        // ADCǂݍ
                LCD_Char_Position(0u,14u);                          //
                sprintf(buff,"%2d %", ADC_VR2_in / 10);             // {[1/10\(Max25)
                LCD_Char_PrintString(buff);                         //
                

                if(For_SW == 0){                                    // gOXCb`ForȂ
                    Through_set = 2;                                // Through_set 2 
                }
                else if(Rev_SW == 0){                               // gOXCb`RevȂ
                    Through_set = 0;                                // Through_set 0 
                }
                else{                                               //@gOXCb`^񒆂Ȃ
                    Through_set = 1;                                //@Through_set 1 
                }
                
                LCD_Char_Position(1u,14);                           //
                sprintf(buff,"%2d %", Through_set);                 // Through_setLCDɕ\
                LCD_Char_PrintString(buff);                         //
            }
            Rate_Set = ADC_VR2_in / 10;                             // {[l1/10[gƂ
            Through = Through_set;                                  // Through_set̕ۑl    
            
            Stop_time_set = Stop_time;                              // Ԏ
            // EEPROݍ
            eeprom_write(3, AutoMode_set);                          // ^][hۑlEEPROMɏ
            eeprom_write(4, Stop_time);                             // ԎԕۑlEEPROMɏ
            eeprom_write(5, Rate_Set);                              // [gۑlEEPROMɏ
            eeprom_write(6,Through_set);                            // ZT[ʉߕۑlEEPROMɏ
            
            LCD_Clear();                                            // LCD\NA[
            LCD_Char_Position(0u,0u);                               //
            LCD_Char_PrintString("Please");                         // {[Minimumɂ悤\
            LCD_Char_Position(1u,2u);                               //
            LCD_Char_PrintString("Minimum Volume");                 //
        
            while(ADC_VR2_in >= 4){                                 // {[MinimumɂȂ܂Ń[v
                ADC_input();                                        // ADCǂݍ
                __delay_ms(10);                                     // 10msҋ@
            }
            while(PushSW == 0){                                     //  PushXCb`Ăԃ[v
            }
            LCD_Clear();                                            // LCD\NA[
            __delay_ms(10);                                         // 10msҋ@
            INTCONbits.GIE = 1;                                     //S荞݋
        }
    }
}

//************************************************************************
//    PORT Initialize
// ***********************************************************************
// PIC ̏
void Initialize (void) {

    // PIC16F18855
    OSCCON1 = 0b01100000;                                           // Clock Source"HFINTOSCwith2xPLL;Clock divider"1"
    //OSCCON2 = 0b01100000;                                   @      // 32MHz
    ANSELA = 0b11100000;                                            // RA7,RA6,RA5AiO[hASẴsfW^[hɐݒ
    ANSELB = 0b00001100;                                            // RB3,RB2AiO[hASẴsfW^[hɐݒ
    ANSELC = 0b00000000;                                            // SẴsfW^[hɐݒ
    //ANSELE = 0b00000000;                                            // RE3fW^[hɐݒ
    
    TRISA = 0b11100000;                                             // RA7,RA6,RA5́ASẴso͂ɐݒ
    TRISB = 0b00111100;                                             // RB5,RB4,RB3,RB2́ASẴso͂ɐݒ
    TRISC = 0b11000000;                                             // RC7,RC6́ASẴso͂ɐݒ
    //TRISE = 0b00001000;                                             // RE3̃s͂ɐݒ

    WPUA  = 0b11001111;                                             // LCDf[^sƁAZT[̓sɃvAbvt
    WPUB  = 0b00000000;                                             // SẴsɃuAbvtȂ
    WPUC  = 0b00111001;                                             // SẴsɃuAbvtȂ
    //WPUE  = 0b00000000;                                             // SẴsɃuAbvtȂ

    PORTA = 0b00001111;                                             // SĂ̏o̓|[gHiɂ
    PORTB = 0b11000011;                                             // SĂ̏o̓|[gHiɂ
    PORTC = 0b00111111;                                             // SĂ̏o̓|[gHiɂ
    //PORTE = 0b00001000;                                             // SĂ̏o̓|[gHiɂ

    //PWM Prot SET
    PPSLOCKbits.PPSLOCKED = 0;                                      // PPS not lockd
    RC1PPS = 0b00001001;                                            // CCP1RC1ɐݒ(CW)
    RC2PPS = 0b00001010;                                            // CCP2RC2ɐݒ(CCW)
    PPSLOCKbits.PPSLOCKED = 1;                                      // PPS Lockd
    
    // Timer2 ݎ̐ݒBBB
    // 1:1̏ꍇɂPWMON/OFFŖŊ荞ݔ
    // 1:16̏ꍇɂPWMON/OFF161񊄂荞ݔ
    T2CONbits.T2OUTPS = 0b0000;                                     // Postscaler is 1:1
    //T2CONbits.T2OUTPS = 0b0001;                                     // Postscaler is 1:2
    //T2CONbits.OUTPS = 0b0011;                                       // Postscaler is 1:4
    //T2CONbits.T2OUTPS = 0b0111;                                     // Postscaler is 1:8

    // Timer2 PWM̐ݒBBB
    // {Iɂ128Őݒ(Feedbackgp)
    // FeedbackgpȂ1ɐݒ肵32kHzPWMo͂\
    //T2CONbits.CKPS = 0b000;                                         // Prescaler is 1(32kHz)
    //T2CONbits.CKPS = 0b001;                                         // Prescaler is 2(16kHz)
    //T2CONbits.CKPS = 0b010;                                         // Prescaler is 4(8kHz)    
    //T2CONbits.CKPS = 0b011;                                         // Prescaler is 8(4kHz) tB[hobN͎Ȃ   
    //T2CONbits.CKPS = 0b100;                                         // Prescaler is 16(2kHz)mCY & tB[hobNd荞ݎēdĂ    
    //T2CONbits.CKPS = 0b101;                                         // Prescaler is 32(1kHz)mCY
    //T2CONbits.CKPS = 0b110;                                         // Prescaler is 64(500Hz)኱mCY    
    T2CONbits.CKPS = 0b111;                                         // Prescaler is 128(250Hz)ԉ͋CɂȂȂH
     
    PR2 = 249;                                                      // TIMER2 PERIOD REGISTER()

    //@̌vZ@@31.25KHz * Prescaler1/1 * 1/PR2(249+1) = 125Hz(8ms)
    //@̌vZ@@8MHz * Prescaler1/128 * 1/PR2(249+1) = 250Hz(4ms)
    
    CCPR1H = DriveL;                                                // CCP1 Register High Byte(Duty)
    CCPR2H = DriveL;                                                // CCP2 Register High Byte(Duty)
        
    // DutyvZ@CCPR1H / PR2 = 50 / (249+1) = 20%

    T2CLKCON = 0b0001;                                              // Clock Select Fosc/4 (8MHz) OUT Clock(250Hz - 32KHz)
    //T2CLKCON = 0b0101;                                            // Clock Select MFINTOSC 31.25KHz OUT Clock(0.9765625Hz - 125Hz)
    
    CCP1CON = 0b10011111;                                           // CCP1 Module Enable;Left aligned format;PWM mode
    CCP2CON = 0b10011111;                                           // CCP2 Module Enable;Left aligned format;PWM mode
                
    T2CONbits.ON = 1;                                               // Timer2 is on

    // Timer1ݐݒ
    T1CON = 0b00110010;                                             //NbN4̂PŁCvXP[1:8ŃJEg
    TMR1H = 0xD8;                                                   //^C}[P̏i65536-10000=55536);
    TMR1L = 0xF0;
    //TMR1IF = 0;                                                     //^C}[P荞݃tOOɂ
    T1CLK = 0b00000001;
    T1CONbits.ON = 1;                                               // Timer1 is on
    
    //ADC CLK SET
    ADCLK = 0b00001111;                                             // Fosc/32
    
}        

// ************************************************************************ 
//                              Main Start
// ************************************************************************
int main(int argc, char** argv) {

    Initialize ();                                                  // |[g

    LCD_Init ();                                                    // LCD 
    LCD_Clear();                                                    // LCD \NA[
    
    // EEPROMǂݍ
    ADC_GAIN_set = eeprom_read(0);                                  // tB[hobNQCۑl
    LIGHT_ON_set = eeprom_read(1);                                  // 펞_ۑl
    Gmode        = eeprom_read(2);                                  // tB[hobNQC̔{ۑl(x1 Coreless@x3 Nolmal x6 Slow)
    AutoMode_set = eeprom_read(3);                                  // ^][hۑl
    Stop_time_set= eeprom_read(4);                                  // ^]Ԏԕۑl
    Rate_Set     = eeprom_read(5);                                  // ^]ۑl
    Through_set  = eeprom_read(6);                                  // ^]wʉ߉񐔕ۑl
    
    Through = Through_set;                                          
    
    LCD_Char_Position(0u,0u);                                       //@I[vjO
    LCD_Char_PrintString("P'sTec PowerPack");                       //
    LCD_Char_Position(1u,0u);                                       //
    LCD_Char_PrintString("PIC16F18855 R1.0");                       //
    
    __delay_ms(2000);                                               // I[vjOʕ\
    LCD_Clear();                                                    // LCD\NA[
    
    //  Timer1݋
    PIE4bits.TMR1IE = 1;                                            // Timer1荞݋

    // Timer2݋
    PIE4bits.TMR2IE = 1;                                            // Timer2荞݋

    INTCONbits.PEIE = 1;                                            // ӊ荞݋

    INTCONbits.GIE = 1;                                             // O[o荞݋

    while (1) {
        if (after_int == 1) {                                       // 荞݃^C~O̓xɃ[v
            //INTCONbits.GIE = 0;
            //LED_Green = 0;
    
            GAIN_set();                                             // GAINݒ
            L_on_set();                                             // 펞_ݒ
            Auto_Mode_Set();                                        // ^][hݒ
            
            if (Manu_Auto == 0) {                                   // ^]ɃX[
                if (For_SW == 0) {                                  // XCb`OiFORȂ
                    CW_CCW = 0;                                     // tO"0"
                }
                if (Rev_SW == 0) {                                  // XCb`iREVȂ
                    CW_CCW = 1;                                     // tO"1"
                }
            }
            if (For_SW == 1 && Rev_SW == 1) {                       // XCb`~STOPȂ
                CW_CCW = 2;                                         // tO"2"
                Manu_Auto = 0;                                      // ^]tO"0"蓮ɂ
                sen_flg = 0;                                        //@oZT[(sen1 sen2)̃tONA[
                FB_val = 0;                                         //@tB[hobNώZlNA[
                time_dely = 300;                                    // ZT[2xǂݖh~fBC(3s) 
            }
            
            // ************************************
            //      POINT Set
            // ***********************************
            
            if(Manu_Auto == 0){                                     // ^]ɂ̓X[
                //POINT1
                if( PointSW1 == 1 ){ Point1_out = 1; }              // PointSW1ɏ]ă|Cg1؂ւ
                else{ Point1_out = 0; }                                    //
            
                //POINT2
                if( PointSW2 == 1 ){ Point2_out = 1; }              // PointSW2ɏ]ă|Cg2؂ւ
                else{ Point2_out = 0; }                                    //
            }
            // *********************
            // FeedbackvZ
            // *********************
            //
            // 8ms^C}[荞݂pϐ
            //
            // ADC_VR2_in BBBx{[ADl 0-255
            // ADC_FB_val BBBtB[hobNdADl 0-255 x Gmode
            // ADC_GAIN_set BBBQCݒl 0-32
            // Sen1_in BBBZT[1ADl 0-255
            // Sen2_in BBBZT[2ADl 0-255
    
            ADC_input();                                            // ADCǂݍ
            
            if (ADC_VR2_in >= ADC_FB_val * Gmode) {                 // Feedbackd{[l菬
                FB_val = FB_val + 2;                                // tB[hobNlFB_val 2 Z
                if(FB_val >= 512){                                  // tB[hobNlő𒴂 512Ƃ
                    FB_val = 512;
                }
            }
            if (ADC_VR2_in < ADC_FB_val * Gmode) {                  // Feedbackd{[l傫
                FB_val = FB_val - 6;                                // tB[hobNlFB_val 6 Z
                if(FB_val <= -512){                                 // tB[hobNlŏ𒴂 -512Ƃ
                    FB_val = -512;
                }
            }
            if (ADC_GAIN_set <= 0 || ADC_VR2_in <= 2) {             // Feedback̏
                FB_val = 0;                                         // tB[hobNlNA[
                FB_chk_val = 0;                                     // tB[hobNlNA[
                
            }
            else{                                                   // FeedbackL̏
                FB_chk_val = FB_val / (10 - ADC_GAIN_set);          // tB[hobNľvZ
                if (FB_chk_val <= 1 && FB_chk_val >= -1 ) {         // o͂FB̕ωႢƃtB[hobNȂȂ鎞̏
                    FB_chk_val = 1;                                 // FeedbackGAIN܂߂vZ
                }
                if(FB_chk_val >= 128){                               // tB[hobN̍ől50%𒴂̂50%Ƃ
                    FB_chk_val = 128;
                }
            }
            if(ADC_VR2_in + FB_chk_val <= LIGHT_ON_set){            // tB[hobNlZo͒l펞_l
                Speed = LIGHT_ON_set;                               // PWMo͒l펞_lƂ
            }
            else{
                Speed = ADC_VR2_in + FB_chk_val;                    // {[lƃtB[hobNlZPWMo͂
            }
                
            if (Speed >= 204){                                      // PWM(PR2)̍ől𒴂Ă(PR2̍ől255ł邪80%)
                Speed = 204;                                        // PWM(PR2)̍őlɂ
            } 
            else if (Speed <= 0) {                                  // PR2̍ŏl𒴂Ă
                Speed = 0;                                          // PR2̍ŏlɂ
            }
            
            if(For_SW == 1 && Rev_SW == 1){                         // gOXCb`^񒆂ɂȂ
                Speed = 0;                                          // PWMo͒l 0 ɂ
                FB_val = 0;                                         // tB[hobNlNA[
            }

            // PWMo
            PWM_out();                                              // ϐSpeed̒lPWMo
            
            if(CW_CCW != 2){                                        // XCb`STOPłȂ
                Sensor_on();                                        // Sensoro
            }
        
            // LCD\
            sprintf(buff,"Vol%3d%% ", ((ADC_VR2_in * 100) / 255));  // LCDحђl\
            LCD_Char_Position(0u,0u);
            LCD_Char_PrintString(buff);
            
            sprintf(buff," FB%4d%%" , ((FB_chk_val * 100) / 255));  // p[pbN̕␳l̕\
            LCD_Char_Position(1u,8u);
            LCD_Char_PrintString(buff);

            sprintf(buff,"Out%3d%% " , ((Speed * 100) / 255));      // p[pbN̕␳l܂ޏo͂\
            LCD_Char_Position(1u,0u);
            LCD_Char_PrintString(buff);
            
            if(Manu_Auto == 0){                                     //  ^]ɂ̓X[
                LCD_Char_Position(0u,11u);                          //  LCD\
                if(CW_CCW == 0){                                    //
                    LCD_Char_PrintString("  FOR");                  //  gOXCb`̃|WV\
                }
                if(CW_CCW == 1){                                    //
                    LCD_Char_PrintString("  REV");                  //
                }
                else{                                               //
                    LCD_Char_PrintString(" STOP");                  //
                }
                
                if(Gmode == 1){                                     //@GainModeLCD\
                LCD_Char_Position(0u,9u);                           //
                LCD_Char_PrintString("C");                          //  QC[h\
                }
                else if(Gmode == 6){                                //
                    LCD_Char_Position(0u,9u);                       //
                    LCD_Char_PrintString("S");                      //
                }
                else if(Gmode == 3){                                //
                    LCD_Char_Position(0u,9u);                       //
                    LCD_Char_PrintString("N");                      //
                }
                sprintf(buff,"%1d", ADC_GAIN_set);                  // QCݒ\
                LCD_Char_Position(0u,10u);                          //
                LCD_Char_PrintString(buff);                         //
            }
            after_int = 0;                                          // 荞݌̃tONA[
            //INTCONbits.GIE = 1;
        }
    }      
     return (EXIT_SUCCESS);    
}     
            
// ****************************
// PWM֌vZʂPWMɏo
// *****************************
void PWM_out(void){
     
    if(CW_CCW == 0){                                                // CW֓
        CCPR1H = Speed;                                             // CCP1ADCǂݍl
        CCPR2H = DriveL;                                            // CCP2ADCǂݍl
    }
    else if(CW_CCW == 1){                                           // CCW֓
        CCPR2H = Speed;                                             // CCP2ADCǂݍl
        CCPR1H = DriveL;                                            // CCP1ADCǂݍl
    }
    else if(CW_CCW == 2){                                           // ~
        CCPR1H = DriveL;                                            // CCP1ADCǂݍl
        CCPR2H = DriveL;                                            // CCP2ADCǂݍl
    }
}
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      Auto Drive Sensor In      \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void Sensor_on(void){                                              // ^]@
    if(skip_flg == 0){                                                                 
        if(sen_flg !=1){                                                // Sensor flg1Ŗ
            if(Sen1_in >= Slice_level + Hysteresis){                    // Sensor1Hi̎(1023=5V) 716=3.5V
                Sen1_flg = 1;                                           // Sen1_flg1ɂ(Sensor1xǂ񂾎\tO)
            }
        }
        if(sen_flg !=2){                                                // Sensor flg2Ŗ
            if(Sen2_in >= Slice_level + Hysteresis){                    // Sensor2Hi̎(1023=5V) 716=3.5V
                Sen2_flg = 1;                                           // Sen1_flg2ɂ(Sensor2xǂ񂾎\tO)
            }
        }
    
        if(Sen1_flg == 1){                                              // Sensor1̃tOSetĂBBB(ZT[JHiɂȂ)
            if(Sen1_in <= Slice_level - Hysteresis){                    // Sensor1Low̎(1023=5V) 716=3.5V 
                if(sen_flg != 1){                                       // Sensor flg1Ŗ
                    if(Through == 0){                                   // wX[邩H 0ɂȂ
                        sen_flg = 1;                                    // Sensor flg1ɂ
                        Auto_drv();                                     // Auto_driv
                        Sen1_flg = 0;
                        Through = Through_set;                          // wԌɃX[lēǂݍ
                    }
                    else{
                        Through--;                                      // ZT[ʉߎZ
                        time_dely = 300;                                // ZT[2xǂݖh~fBC(3s)
                    }
                }
            }
        }
        if(Sen2_flg == 1){                                              // Sensor2̃tOSetĂBBB(ZT[JHiɂȂ)
            if(Sen2_in <= Slice_level - Hysteresis){                    // Sensor2Low̎(1023=5V) 716=3.5V
                if(sen_flg != 2){                                       // Sensor flg2Ŗ
                    if(Through == 0){                                   // wX[邩H 0ɂȂ
                        sen_flg = 2;                                    // Sensor flg2ɂ
                        Auto_drv();                                     // Auto_driv
                        Sen2_flg = 0;                                   // Sensor2 flgNA[
                        Through = Through_set;                          // wԌɃX[lēǂݍ
                    }
                    else{
                        Through--;                                      // ZT[ʉߎZ
                        time_dely = 300;                                // ZT[2xǂݖh~fBC(3s)
                    }
                }
            }
        }
    }
}

// *****************************
//          ^]
// *****************************
void Auto_drv(void){
    if(AutoMode_set != 2){                                          // [hOptionłȂƂ(Option̓܂lĂȂ)
        INTCONbits.GIE = 0;                                         // ^]̉AA~͑S荞݋֎~
        LCD_Char_Position(0,9);                                     // J[\1s12
        LCD_Char_PrintString("AUTO");                               // LCD\"AUTO"        
  
        Manu_Auto = 1;                                              // auto drive flgset

        LCD_Char_Position(0,13);                                    // J[\1s8
        if(sen_flg == 0){                                           // ZT[o
            LCD_Char_PrintString("   ");                            // LCD\NA[
        }
        if(sen_flg == 1){                                           // ZT[1o
            LCD_Char_PrintString(" S1");                            // LCD\"S1"
        }
        if(sen_flg == 2){                                           // ZT[2o
            LCD_Char_PrintString(" S2");                            // LCD\"S2"
        }
    
        while(Speed >= LIGHT_ON_set){                               // PWMo͒l_l傫ꍇ
            PWM_out();                                              // PWMo

            // 
            Speed--;                                                // PWMo͒l-1
            FB_val = 0;                                             // tB[hobNlNA[
            FB_chk_val = 0;                                         // tB[hobNlNA[

            LCD_Char_Position(1,3);                                 // J[\2s2
            sprintf(buff, "%3d", (Speed * 100) / 255);              // PWMo͒l
            LCD_Char_PrintString(buff);                             // \

            LCD_Char_Position(1,12);                                // J[\2s11
            sprintf(buff, "%4d", (FB_chk_val * 100) / 255);         // tB[hobNl
            LCD_Char_PrintString(buff);                             // LCD\

            Dec_rate = Rate_Set * 2;                                // [gw({ύXΌ݂̂̃[gύX)
            while(Dec_rate >= 0){
            __delay_ms(1);                                          // fBC
            Dec_rate--;
            }
        }
                            
        Point1_out = !Point1_out;                                   // POINT1̔]
        //Point2_out = !Point2_out;                               // Point2̔]
        
        // Ԓ
        Stop_time = Stop_time_set * 10;                             // ݒlϐStop_time
        while(Stop_time >= 0){                                      // Stop_time0ɂȂ烋[v
            __delay_ms(100);                                        // 100msҋ@
            
            ADC_input();                                            // ADCǂݍ
            LCD_Char_Position(0,3);                                 // J[\1s2
            sprintf(buff, "%3d", (ADC_VR2_in * 100) / 255);         // Volumel
            LCD_Char_PrintString(buff);                             // \
                              
            if(For_SW == 1 && Rev_SW == 1){                         // gOXCb`StopɂȂ
                Stop_time = 0;                                      // ϐStop_time 0 ɂ
            }
            Stop_time--;                                            // ϐStop_timeZ
        }
        if(For_SW == 0 || Rev_SW == 0){                             // gXCb`StopȂȉWv
                        
            // Ԓ
            if(AutoMode_set == 0){                                  // ^胂[h 0 Ȃ
                CW_CCW = !CW_CCW;                                   // is]
            }
           
            // |Cg؂ւ
            //Point1_out = !Point1_out;                               // POINT1̔]
            Point2_out = !Point2_out;                               // Point2̔]

            __delay_ms(1);                                          // 1msҋ@(rbg삪AƐ̑삪ȂȂ)
            LED_Green = 1;                                          // ZT[XLbv\
            
            // i
            Accel = LIGHT_ON_set;                                   // lݒ
            
            while(ADC_VR2_in > Accel){                              // {[ll菬Ƀ[v
                Speed = Accel;                                      // ԏo͂Speedϐ
                PWM_out();                                          // PWMo
                Accel++;                                            // SpeedϐZ

                LCD_Char_Position(0,3);                             // J[\1s2
                sprintf(buff, "%3d", (ADC_VR2_in * 100) / 255);     // Volumel
                LCD_Char_PrintString(buff);                         // \

                LCD_Char_Position(1,3);                             // J[\2s4
                sprintf(buff, "%3d", (Speed * 100) / 255);          // PWMo͒lҏW
                LCD_Char_PrintString(buff);                         // \

                LCD_Char_Position(1,12);                            // J[\2s11
                sprintf(buff, "%4d", (FB_chk_val * 100) / 255);     // tB[hobNlҏW
                LCD_Char_PrintString(buff);                         // LCD\
       
                Acc_rate = Rate_Set * 8;                            // [gw({ύXΉ݂̂̃[gύX)
                while(Acc_rate >= 0){                               // [g 0 ɂȂ܂őҋ@
                __delay_ms(1);                                      // fBC
                Acc_rate--;                                         // [gZ
                }
            }
        }
        time_dely = 600;                                            // ZT[2xǂݖh~fBC(6s) 
        INTCONbits.GIE = 1;                                         // S荞݋
    }
}