/* 
 * File:  Char_LCD.c
 * Author: P'sTec
 *
 *Created on 2020/01/10
 * 
 * https://gputils.sourceforge.io/html-help/PIC16F18855-conf.html
 * 
 * PIC16F18855 PWM POWER PACK
 * 
 * Soft by Higuma
 * 
 */


#include <xc.h>
#include "Char_LCD.h"

#define _XTAL_FREQ 32000000                     // __delay_ms()pNbN`
#define LCD_BACK_Light  RC0


// PIC-LCDPin

#define	LCD_RS 	PORTCbits.RC3                   // LCD_RSRC3w
#define LCD_RW 	PORTCbits.RC4                   // LCD_RWRC4w
#define LCD_E	PORTCbits.RC5                   // LCD_E RC5w
#define LCD_DATA PORTA
#define LCD_DATA_IS_LOW // PortC̉4bitLCDDB4-7ɐڑ

static void LCD_Write_CMD( unsigned char data );
static void LCD_Write_Data( unsigned char data );


//*****************************************************************************
// Function : LCD_Init
// Description: LCD(4bit[h)
//*****************************************************************************
void LCD_Init( void ){

	// *******************
	//  s̏
	// *******************

	LCD_RS = 0;
    __delay_us(1);
	LCD_RW = 0;
    __delay_us(1);
	LCD_E  = 0;
    __delay_us(1);
	
	LCD_DATA = (LCD_DATA & 0xf0);
	//__delay_ms( 100 );                        // 100ms delay

	// *****************
	//  LCD
	// *****************

    LCD_Write_CMD( 0x03 );
	__delay_ms( 2 );                            // 2ms delay
    LCD_Write_CMD( 0x03 );
	__delay_ms( 2 );                            // 2ms delay
    LCD_Write_CMD( 0x03 );
	__delay_ms( 2 );
    LCD_Write_CMD( 0x02 );                      // 4bit[hɕύX
	__delay_ms( 2 );
	LCD_Write_CMD( 0x28 );                      // Function Set(4bit,2line,5x7dot)
	__delay_us( 100 );
	LCD_Write_CMD( 0x08 );                      // Display ON/OFF(Display OFF,Cursor OFF,Blink OFF)
	__delay_us( 100 );
	LCD_Write_CMD( 0x01 );                      // Clear Display
	__delay_ms( 2 );
	LCD_Write_CMD( 0x06 );                      // Entry Mode(I/D Light Shift)
	__delay_us( 100 );
	LCD_Write_CMD( 0x0C );                      // Display ON/OFF(Display ON)
	__delay_us( 100 );
    
    LCD_BACK_Light = 0;                         // LCD Backlaight ON
}

//*****************************************************************************
// Function : LCD_Char_Position
// Description : \ʒuw
//*****************************************************************************
void LCD_Char_Position( unsigned char x, unsigned char y ) {
	unsigned char Position_Data;

	Position_Data = 0x40 * x + y;               // \ʒu(2sڂɏoƂ,3bitڂ𗧂Ă)
	Position_Data |= 0x80;                      // ŏʃrbg𗧂Ă
	LCD_Write_CMD( Position_Data );
}

//*****************************************************************************
// Function : LCD_Clear
// Description : LCD\Clear
//*****************************************************************************
void LCD_Clear() {
	LCD_Write_CMD( 0x01 );                      // Clear Display
   	__delay_ms( 2 );                            // 2ms delay 
    LCD_Write_CMD( 0x01 );                      // Clear Display
	__delay_ms( 2 );                            // 2ms delay
}

//*****************************************************************************
// Function : LCD_Write_Print
// Description : LCD 1o
//*****************************************************************************
void LCD_Write_Print( char c ) {
	LCD_RS = 1;                                 // Data Register Set
    __delay_us(1);
    
	LCD_Write_Data( (c & 0xf0) >> 4 );
	LCD_Write_Data( (c & 0x0f) );
}

//*****************************************************************************
// Function : LCD_PrintString
// Description : LCDɕo
//*****************************************************************************
void LCD_Char_PrintString( const char *p ) {
	while( *p != '\0' ) {
		LCD_Write_Print( *p );
		p++;
	}
}

//*****************************************************************************
// Function : LCD_Write_CMD
// Description : 4bit[hł̖ߏ(RS=LOW)
// ߂͏ʃrbg珇ɑ
//*****************************************************************************
static void LCD_Write_CMD( unsigned char data ) {
	LCD_RS = 0;                                 // Command Register Set
    __delay_us(1);
    
	LCD_Write_Data( (data & 0xf0) >> 4 );
	LCD_Write_Data( (data & 0x0f) );
}

//*****************************************************************************
// Function : LCD_Write_Data
// Description : dataŎw肳ꂽ4bit̃f[^DB4-7ɏ
//*****************************************************************************
static void LCD_Write_Data( unsigned char data ) {
    // ݃f[^Zbg
    LCD_DATA = (LCD_DATA & 0xf0) | (data & 0x0f);

    __delay_us( 1 );
    LCD_RW = 0;                                 // Write Set
    __delay_us(1);
    LCD_E = 1; 
	__delay_us( 30 );

	// f[^荞݃^C~O
	LCD_E = 0;                                  // Disable Set 
	__delay_us(1);
    LCD_RW = 1;                                 // Read Set
	__delay_us(1);
}