/* 
 * File:   main.c
 * Author: P'sTec
 *
 * Created on 2019/10/10
 * LastupDate 2020/01/14
 * 
 * https://gputils.sourceforge.io/html-help/PIC16F18325-conf.html
 * 
 * PIC16F18325 PWM POWER PACK
 * 
 * Soft by Higuma
 * 
 */
// CONFIG1
#pragma config FEXTOSC = OFF    // FEXTOSC External Oscillator mode Selection bits (Oscillator not enabled)
#pragma config RSTOSC = HFINT32 // Power-up default value for COSC bits (HFINTOSC with 2x PLL (32MHz))
#pragma config CLKOUTEN = OFF   // Clock Out Enable bit (CLKOUT function is disabled; I/O or oscillator function on OSC2)
#pragma config CSWEN = ON       // Clock Switch Enable bit (Writing to NOSC and NDIV is allowed)
#pragma config FCMEN = ON       // Fail-Safe Clock Monitor Enable (Fail-Safe Clock Monitor is enabled)

// CONFIG2
#pragma config MCLRE = OFF       // Master Clear Enable bit (MCLR/VPP pin function is MCLR; Weak pull-up enabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config WDTE = OFF       // Watchdog Timer Enable bits (WDT disabled; SWDTEN is ignored)
#pragma config LPBOREN = OFF    // Low-power BOR enable bit (ULPBOR disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable bits (Brown-out Reset enabled, SBOREN bit ignored)
#pragma config BORV = LOW       // Brown-out Reset Voltage selection bit (Brown-out voltage (Vbor) set to 2.45V)
#pragma config PPS1WAY = ON     // PPSLOCK bit One-Way Set Enable bit (The PPSLOCK bit can be cleared and set only once; PPS registers remain locked after one clear/set cycle)
#pragma config STVREN = ON      // Stack Overflow/Underflow Reset Enable bit (Stack Overflow or Underflow will cause a Reset)
#pragma config DEBUG = OFF      // Debugger enable bit (Background debugger disabled)

// CONFIG3
#pragma config WRT = OFF        // User NVM self-write protection bits (Write protection off)
#pragma config LVP = OFF         // Low Voltage Programming Enable bit (Low Voltage programming enabled. MCLR/VPP pin function is MCLR. MCLRE configuration bit is ignored.)

// CONFIG4
#pragma config CP = OFF         // User NVM Program Memory Code Protection bit (User NVM code protection disabled)
#pragma config CPD = OFF        // Data NVM Memory Code Protection bit (Data NVM code protection disabled)

// MCLRRA3̎g
// MCLREEEMCLRE/ON  LVP/ON
// RA3 EEEMCLRE/OFF  LVP/OFF
// Power PackłRA3ƂĎgp邽߁AMCLRELVP͋OFFɂ܂

#include <stdio.h>
#include <stdlib.h>
#include <xc.h>
#include "pic16F18325.h"

// NbNgw
// (__delay_ms()֐KvƂĂ邽)
#define _XTAL_FREQ  32000000

typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
typedef signed   char   int8;
typedef signed   short  int16;
typedef signed   long   int32;
typedef          float  float32;

#define PWM_DELEY_TIME   1500                                       // PWMdeleyԁB1500us
#define AUTO_STOP_VAL    20                                         // 10ms x 1Volume  Volumel50ƂďꍇA10ms x 30 x 50 = 15s

uint8  CW_CCW = 0;
uint8  Manu_Auto = 0;
int16  Speed = 0;
int16  StopSpeed = 0;
uint8  DriveL = 0;
uint8  DriveH = 250;
int16  FB_writ = 0;
int16  FB_writ2 = 0;
int8   chk_censor = 2;                                              // ÕZT[ԍ 0ԁA1ԁA܂͂̑
int16  ADC_FB_val = 0;
int16  ADC_VR1_in = 0;
int16  ADC_VR2_in = 0;
int8    ADC_GAIN_in = 8;                                           // FeedbackGAINl
uint16  Sen1_in = 255;
uint16  Sen2_in = 255;
uint8   Sen1_err = 0;
uint8   Sen2_err = 0;                                               // ݃ZT[XCXx͗グɃxĕύXĂ
uint16  Slice1_level = 143;                                         // 2.8VZbg̏ꍇ@5V / 256 = 0.01953125V
uint16  Slice2_level = 143;                                         // 2.8V / 0.01953125V = 143
uint8   Hysteresis = 4;                                             // 0.01953125V * 4 =0.0781255V
uint8   RC0_Dig = 1;
uint8   RC1_Dig = 1;

char   auto_drive_mode = 0;                                         // 0=ȉ~2w[h/1=P[h
uint8  after_8ms = 0;

__EEPROM_DATA (0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);     // EEPROM̏lB8oCgPʂŏ邱ƁB
                                                                    // 1ByteڂDownloadGAINl(08)
// Function
void ADC_input(void);                                              // ACDϊ͏
void go_wait(void);                                                // GOω҂
void GAIN_set(void);                                               // Feedback Gainݒ菈
void PWM_out(void);                                                // PWMo
void AUTO_Mode(void);

// ******************************
// 荞ݏ
// ******************************
void __interrupt() isr(void)
{
    //Timer1̊荞݂Ȃ(10ms)
    if (TMR1IF == 1) { 
        TMR1IF = 0;
//        PIR1bits.TMR1IF = 0;                                      // ^C}1݃tONA
                
    }

    //Timer2̊荞݂Ȃ(8ms)
    else if (TMR2IF == 1) { 
        TMR2IF = 0;
        PIR1bits.TMR2IF = 0;                                        // ^C}2݃tONA
        
        ADC_input();                                                // ADC荞ݏ
    }
}

// ******************************
//  GOω҂
// ******************************
void go_wait(void)
{
    __delay_us(10);                                                 // 10us Delay@(ANCW^C)
    GO = 1;                                                         // ADCϊStart
    while( GO );                                                    // ADCϊI܂őҋ@
}

// ******************************
// ADCǂݍݏ
// ******************************
void ADC_input(void)
{
    //RA2 = 1;                                                      // IVŃ^C~O`FbNp
    
    // +++++++++++++++++++++++
    // x{[l荞
    // +++++++++++++++++++++++
    ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
    ADCON0 = 0b01010101;                                            // ANC5ADCϊɐݒ
    go_wait();                                                      // GOω҂
    ADC_VR2_in = ADRESH;                                            // x{[̒lVR2_in
    
        // +++++++++++++++++++++++++++
    // 펞_{[l荞
    // +++++++++++++++++++++++++++
    ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
    ADCON0 = 0b01010001;                                            // ANC4ADCϊɐݒ
    go_wait();                                                      // GOω҂
    ADC_VR1_in = (ADRESH / 5);                                      // VR1̒l荞1/5Lampɑ
    
    // ++++++++++++++++++++++++++++++
    // FEED BACKǂݎ^C~O҂
    // ++++++++++++++++++++++++++++++
    __delay_us(PWM_DELEY_TIME);                                     // 1500us Delay@(2000us)

    // ++++++++++++++++++++++
    // Feedbackd̎荞
    // ++++++++++++++++++++++
    
    // isɂAD̎荞݃|[gقȂ
    if (CW_CCW == 0) {
        ADCON1 = 0b00100000;                                        // l;Fosc/32;AVss/VDD
        ADCON0 = 0b00000001;                                        // ANA0ADCϊɐݒ
        go_wait();                                                  // GOω҂
        ADC_FB_val = (ADRESH * 2);                                  // Feedback̒l2{ɂĎ荞
    }
    else if (CW_CCW == 1) {
        ADCON1 = 0b00100000;                                        // l;Fosc/32;AVss/VDD
        ADCON0 = 0b00000101;                                        // ANA1ADCϊɐݒ
        go_wait();                                                  // GOω҂
        ADC_FB_val = (ADRESH * 2);                                  // Feedback̒l2{ɂĎ荞
    }
    if (ADC_FB_val >= 512) {                                        // PR2̍ől𒴂Ă
        ADC_FB_val = 512;                                           // PR2̍őlɂ
    }
    //RA2 = 0;
    // ++++++++++++++++++++++++++    
    // ʒuZT[l̓ǂݎ(1)
    // ++++++++++++++++++++++++++    
    ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
    ADCON0 = 0b01000001;                                            // ANC0ADCϊɐݒ
    go_wait();                                                      // GOω҂
    Sen1_in = ADRESH;                                               // ZT[(1)̒lSen1_in
    
    // ++++++++++++++++++++++++++
    // ʒuZT[l̓ǂݎ(2)
    // ++++++++++++++++++++++++++
    ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
    ADCON0 = 0b01000101;                                            // ANC0ADCϊɐݒ
    go_wait();                                                      // GOω҂
    Sen2_in = ADRESH;                                               // ZT[(2)̒lSen2_in
    
    // +++++++++++++++++++++++++
    // ʒuZT[l2l(1)
    // +++++++++++++++++++++++++
    if (Sen1_in <= Slice1_level- Hysteresis) {                      // XCXxɃZT[lfW^(1)
        RC0_Dig = 0;                                                // ZT[xo(0)
    }
    else {
        RC0_Dig = 1;
    }
    
    // +++++++++++++++++++++++++
    // ʒuZT[l2l(2)
    // +++++++++++++++++++++++++
    if (Sen2_in <= Slice2_level+ Hysteresis) {                      // XCXxɃZT[lfW^(2))
        RC1_Dig = 0;
    }
    else {
        RC1_Dig = 1;
    }

    // +++++++++++++++++++++++
    // ʒuZT[LED\
    // +++++++++++++++++++++++
    if (RC0_Dig == 0 || RC1_Dig == 0) {
        RA2 = 0;
    }
    else {
        RA2 = 1;
    }
    after_8ms = 1;
} 
   
// ******************************
// GAINݒ
// ******************************

void GAIN_set(void) {
    INTCONbits.GIE = 0;                                             // S荞݋֎~
    //Gainݒ
    while( RA3 == 0 && RC2 == 1 && RC3 ==1 && Speed == 0 ){         // PUSHXCb`ĂGAINݒ
        ADCON1 = 0b00100000;                                        // l;Fosc/32;AVss/VDD
        ADCON0 = 0b01010001;                                        // ANC4ADCϊɐݒ
        go_wait();                                                  // GOω҂
        ADC_GAIN_in = (ADRESH / 16);                                // VR1̒l荞1/16ϐɑ

        RA2 = 0;                                                    // GAINݒ莞LED_ł
        if (ADC_GAIN_in >= 1) {                                     // LED_ݒŁAFeedback
            int GAIN_i;                                             // GAINݒ0?1516iK
            for (GAIN_i = 0 ; GAIN_i <= (16-ADC_GAIN_in) ; GAIN_i++) {
                __delay_ms(20);
            }
            RA2 = 1;
            for (GAIN_i = 0 ; GAIN_i <= (16-ADC_GAIN_in) ; GAIN_i++) {
                __delay_ms(20);                                     // ܂
            }
        }
    }
    // EEPROݍ
    eeprom_write(0, ADC_GAIN_in);
  
    INTCONbits.GIE = 1;                                             //S荞݋
}

// ******************************
// MAIN
// ******************************

int main(int argc, char** argv) {
    int16 FB_chk_val = 0;

    // PIC16F18325
    OSCCON1 = 0x00;                                                 // Clock Source"HFINTOSCwith2xPLL(32MHz);Clock divider"1"
    ANSELA = 0b00000011;                                            // RA0,RA1AiO[hASẴsfW^[hɐݒ
    ANSELC = 0b00110000;                                            // RC4,RC5AiO[hASẴsfW^[hɐݒ   
    TRISA = 0b00001011;                                             // RA0,RA1,RA3́ASẴso͂ɐݒ
    TRISC = 0b00111111;                                             // SẴs͂ɐݒ
    WPUC  = 0b00000000;                                             // SẴsɃuAbvtȂ

    PORTA = 0b11110100;                                             // SĂ̏o̓|[gHiɂ
    //PORTC = 0b11111111;                                           // SĂ̏o̓|[gHiɂ
    
    //PWM SET
    PPSLOCKbits.PPSLOCKED = 0;                                      // PPS not lockd
    RA4PPS = 0b00001100;                                            // CCP1RA4ɐݒ(CW)
    //RA5PPS = 0b00001100;                                          // CCP1RA5ɐݒ(CCW)
    RA5PPS = 0b00001101;                                            // CCP2RA5ɐݒ(CCW)
    
    //RA2PPS = 0b00001100;                                          // CCP1RA2ɐݒ(LED)
    
    PPSLOCKbits.PPSLOCKED = 1;                                      // PPS Lockd
    
    // ݎ̐ݒBBB
    // 1:1̏ꍇɂPWMON/OFFŖŊ荞ݔ
    // 1:16̏ꍇɂPWMON/OFF161񊄂荞ݔ
    //T2CONbits.T2OUTPS = 0b0000;                                   // Postscaler is 1:1
    //T2CONbits.T2OUTPS = 0b0001;                                   // Postscaler is 1:2
    T2CONbits.T2OUTPS = 0b0011;                                     // Postscaler is 1:4
    //T2CONbits.T2OUTPS = 0b0111;                                   // Postscaler is 1:8
    
    // PWM̐ݒBBB
    // {Iɂ64Őݒ(Feedbackgp)
    // FeedbackgpȂ1ɐݒ肵32kHzPWMo͂\
    //T2CONbits.T2CKPS = 0b00;                                      // Prescaler is 1
    T2CONbits.T2CKPS = 0b11;                                        // Prescaler is 64
     
    PR2 = 249;                                                      // TIMER2 PERIOD REGISTER()
        
    //@̌vZ@@32MHz/4 * Prescaler1/64 * 1/PR2(249+1) = 500Hz(2ms)
    
    CCPR1H = DriveL;                                                // CCP1 Register High Byte(Duty)
    CCPR2H = DriveL;                                                // CCP2 Register High Byte(Duty)
        
    // DutyvZ@CCPR1H / PR2 = 50 / (249+1) = 20%
    
    CCP1CON = 0b10011111;                                           // CCP1 Module Enable;Right aligned format;PWM mode
    CCP2CON = 0b10011111;                                           // CCP2 Module Enable;Right aligned format;PWM mode
        
    T2CONbits.TMR2ON = 1;                                           // Timer2 is on

    //ADC SET
    //ADCON0 = 0b01010101;                                          // ANC5ADCϊɐݒ
    //ADCON0 = 0b01010001;                                          // ANC4ADCϊɐݒ
    ADCON1 = 0b00100000;                                            // l;Fosc/32;AVss/VDD
    
    // ******************************************
    // ʒuZT[ݒ
    // *******************************************
    
    // dɃZT[̏lǂ݂܂B
    // ̂߁AZT[ɂ͎ԗ╨uȂ悤ɂĉB
    
    ADC_input();                                                    // ADC荞ݏ
    
    if (Sen1_in <= 102) {                                           // 102 * 0.01953125 = 1.99VdႢꍇA
        Sen1_err = 1;                                               // ZT[Ɍ肷Ă邽߃G[Ƃ
    }
    else {
        Slice1_level = Sen1_in * 0.7;                               // d̃ZT[xɑ΂0.6{̃XCXxg
    }
    if (Sen2_in <= 102) {                                           // 102 * 0.01953125 = 1.99VdႢꍇA
        Sen2_err = 1;                                               // ZT[Ɍ肷Ă邽߃G[Ƃ
    }
    else {
        Slice2_level = Sen2_in * 0.7;                               // d̃ZT[xɑ΂0.6{̃XCXxg
    }
    
    // ǂ̃ZT[G[LED̓_Ńp^[ĊmFł܂B
    if (Sen1_err == 1 && Sen2_err == 1) {
        while(1){
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(800);
            RA2 = 1;
            __delay_ms(200);
        }
    }
    if (Sen1_err == 1) {
        while(1){
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(800);
            RA2 = 1;
            __delay_ms(200);
        }
    }
    if (Sen2_err == 1) {
        while(1){
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(200);
            RA2 = 1;
            __delay_ms(200);
            RA2 = 0;
            __delay_ms(800);
            RA2 = 1;
            __delay_ms(200);
        }
    }

    // Timer1ݐݒ
/*
    T1CON = 0b00110001;                                             //NbN4̂PŁCvXP[1:8ŃJEg
    TMR1H = (55536 >>8);                                            //^C}[P̏i65536-10000=55536);
    TMR1L = (55536 & 0x00ff);
    TMR1IF = 0;                                                     //^C}[P荞݃tOOɂ
    //  Timer1݋
    PIE1bits.TMR1IE = 1;                                            // Timer1荞݋
*/

    // Timer2݋
    PIE1bits.TMR2IE = 1;                                            // Timer2荞݋
    
    INTCONbits.PEIE = 1;                                            // ӊ荞݋
    INTCONbits.GIE = 1;                                             // O[o荞݋
    
    // EEPROMǂݍ
    ADC_GAIN_in = eeprom_read(0);
    
        // NPUSH SWĂȂȉ~2w[hB
    if ( RA3 == 1 ) {
        auto_drive_mode = 0;                                        // 0=ȉ~2w[h/1=P[h
    }
    // NPUSH SWĂȂP[hB
    else {
        auto_drive_mode = 1;                                        // 0=ȉ~2w[h/1=P[h
        while ( RA3 == 0 ) {                                        // PUSHXCb`Ă
            // ̂҂
        }
    }
    
    // *******************************************
    //
    // MAIN Loop JԂ
    //
    // *******************************************
    
    while (1) {
        if (after_8ms == 1) {

            // GAINݒ
            if ( RA3 == 0 && RC2 == 1 && RC3 ==1 && Speed == 0 ) {  // GAINݒȂ
                GAIN_set();
            }

            if (Manu_Auto == 0) {                                   // is`FbN
            
                if (RC2 == 0) {                                     // SWFOR
                    CW_CCW = 0;
                }
                if (RC3 == 0) {                                     // SWREV
                    CW_CCW = 1;
                }
            }
            if (RC2 == 1 && RC3 == 1) {                             // SWSTOP
                CW_CCW = 2;                                         // ~
                Manu_Auto = 0;                                      // Manual Mode
                chk_censor = 2;                                     // ÕZT[ԍ 0ԁA1ԁA܂͂̑
                FB_writ = 0;
            }

            //*********************
            // FeedbackvZ
            //*********************
            //
            // 8ms^C}[荞݂pϐ
            //
            // ADC_VR1_in BBBx{[ADl 0-255
            // ADC_VR2_in BBB펞_{[ADl 0-255
            // ADC_FB_val BBBtB[hobNdADl 0-255
            // ADC_GAIN_in BBBQCݒl 0-32
            // RC0_Dig BBBZT[1 ON/OFFl
            // RC1_Dig BBBZT[2 ON/OFFl
    
            if (ADC_VR2_in >= ADC_FB_val) {
                FB_writ = FB_writ + 1;
                if(FB_writ >= 2000){
                    FB_writ = 2000;
                }
                //RA2 = 1;
            }
            if (ADC_VR2_in < ADC_FB_val) {
                FB_writ = FB_writ - 4;
                if(FB_writ <= -2000){
                    FB_writ = -2000;
                }
                //RA2 = 0;
            }
            if (ADC_GAIN_in <= 0) {                                 // Feedback̏
                FB_writ2 = 0;
            }
            else{                                                   // FeedbackL̏
                if (ADC_GAIN_in >= 18 ) {                           // [h~
                    FB_writ2 = 1;
                }
                else {
                    FB_chk_val = FB_writ / (18 - ADC_GAIN_in);
                    if ((FB_chk_val >= 1 ) ||
                        (FB_chk_val <= -1 )) {                      // o͂FB̕ωႢƓȂȂ鎞̏
                        FB_writ2 = FB_chk_val;                      // FeedbackGAIN܂߂vZ
                    }
                    else {
                        FB_writ2 = 1;
                    }
                }
            }
            Speed = ADC_VR2_in + FB_writ2;
            
            if (Speed >= 200){                                      // PR2̍ől𒴂Ă
                Speed = 200;                                        // PR2̍őlɂ
            } 
            else if (Speed <= ADC_VR1_in) {                         // PR2̍ŏl𒴂Ă
                Speed = ADC_VR1_in;                                 // PR2̍ŏlɂ
            }
        
            if (ADC_VR2_in <= 2) {
                Speed = ADC_VR1_in;
                FB_writ = 0;
            }
   
            // PWMo
            PWM_out();
            
            //RA2 = 0;
            
            // Auto Mode
            AUTO_Mode();
            
            //RA2 = 0;
            after_8ms = 0;
            //INTCONbits.GIE = 1;                                   //S荞݋
        }
        // Loop
    }      
     return (EXIT_SUCCESS);    
}     
            
//****************************
// PWM֌vZʂPWMɏo
//*****************************
void PWM_out(void){
        
    if(CW_CCW == 0){                                                // CW֓
        CCPR1H = Speed;                                             // CCP1ADCǂݍl
        CCPR2H = DriveL;                                            // CCP2ADCǂݍl
    }
    else if(CW_CCW == 1){                                           // CCW֓
        CCPR2H = Speed;                                             // CCP2ADCǂݍl
        CCPR1H = DriveL;                                            // CCP1ADCǂݍl
    }
    else if(CW_CCW == 2){                                           // ~
        CCPR1H = DriveL;                                            // CCP1ADCǂݍl
        CCPR2H = DriveL;                                            // CCP2ADCǂݍl
    }
}

// **************************************************
//
//  Auto Mode
//  Sensero(xZT[oAuto[hɓ)
//  isSW~ɂManual[hɖ߂
//
// **************************************************
void AUTO_Mode(void){        
    if ( (RC0_Dig == 0 && chk_censor != 0) ||                       // Sensor0ԂoŁAO0ԏoȂ
         (RC1_Dig == 0 && chk_censor != 1) ) {                      // Sensor1ԂoŁAO1ԏoȂ
            
        Manu_Auto = 1;                                              // Auto Mode Flag
            
        if (RC0_Dig == 0) {                                         // Sensor0Ȃ
            chk_censor = 0;                                         // Sensor0
        }
        else{
            chk_censor = 1;                                         // Sensor1
        }
        // ~
        while(1) {
            Speed = Speed - 1;
            PWM_out();                                              // PWMo
            if (Speed <= ADC_VR1_in) {                              // 펞_{[lɂȂ
                break;                                              // ɐi
            }
            __delay_ms(AUTO_STOP_VAL);
        }

        __delay_ms(5000);
        
        if(auto_drive_mode == 1){
            // is؂ւ
            if(CW_CCW == 0){
                CW_CCW = 1;                                         // ist]
            }
            else{
                CW_CCW = 0;                                         // ist]
            }
        }
        // 
        while(1) {
            Speed = Speed + 1;
            PWM_out();                                              // PWMo
            if (Speed >= ADC_VR2_in){
                break;                                              // ɐi
            }
            __delay_ms(AUTO_STOP_VAL);
        }
    }
}
/*
 *         
 *PWM͏Lݒ500Hz̎gœ삵܂B
 *gύXƂPR2点Ύg͑Ȃ܂B(ő 125kHz)
 *DutyCCPR2HŕύXł܂BőlPR2ƓDuty100%
 * o͐RA4CWBBRA5CCWɂȂ܂B
 * 
*/    
