// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                      P'sTec Higuma
//              Ardino UNO Power Pack Soft
//                      Feedback
//                      Auto
//                                      2020/3/30
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                        Rev.0.1
//    Port Set
//      D0    LED_Blue                AD0   Volume
//      D1    LCD_RS                  AD1   PWM_FB1
//      D2    INT_PWM1                AD2   PWM_FB2
//      D3    INT_PWM2                AD3   Sensor_1
//      D4    SW_FOR                  AD4   Sensor_2
//      D5    SW_REV                  AD5   PushSW
//      D6    LCD_E
//      D7    LCD_BKL
//      D8    LCD_D4
//      D9    PWM_OUT1
//      D10   PWM_OUT2
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7

#include <LiquidCrystal.h>
#include <EEPROM.h>

LiquidCrystal lcd(1, 6, 8, 11, 12, 13);                             //　LCDポート設定

int LED_Blue = 0;                                                   // Blue LED出力ピン
int INT_PWM1 = 2;                                                   // PWM1割り込み入力ピン
int INT_PWM2 = 3;                                                   // PWM2割り込み入力ピン
int SW_FOR = 4;                                                     // SW_FOR入力ピン
int SW_REV = 5;                                                     // SW_REV入力ピン
int PWM_OUT1 = 9;                                                   // PWM_OUT1(For方向)出力ピン
int PWM_OUT2 = 10;                                                  // PWM_OUT2(Rev方向)出力ピン
int LCD_BKL = 7;                                                    // LCD_BKL出力ピン
int Volume = 0;                                                     // ボリューム　アナログ入力ピン
int PWM_FB1 = 1;                                                    // PWMフィードバック1　アナログ入力ピン
int PWM_FB2 = 2;                                                    // PWMフィードバック2　アナログ入力ピン
int Sensor_1 = 3;                                                   // Sensor1 アナログ入力ピン
int Sensor_2 = 4;                                                   // Sensor2 アナログ入力ピン
int PushSW = 5;                                                     // PushSW　アナログ入力ピン

int val = 0;                                                        // ボリューム読み込み値
char buff[16];                                                      // 変数 LCD表示文字
volatile int state = RISING;
int Dig = 2;                                                        // 進行方向フラグ
int FB = 0;                                                         // フィードバック値
int val_fb = 0;                                                     // フィードバック値
int Sen1 = 0;                                                       // センサー1読み込み値
int Sen2 = 0;                                                       // センサー2読み込み値
int sen_flg = 0;                                                    // センサーフラグ
int auto_d = 0;                                                     // "0" = Manual  "1" = Auto Drive
int n = 0;                                                          // 自動運転減速時変数
int GainN = 50;                                                     // 読み込み周回値
int val_out = 0;                                                    // PWM出力値
int FB_Read = 0;                                                    // フィードバック電圧読み出し値
int Accel = 0;                                                      // 自動運転加速時変数
int Sen1_flg = 0;                                                   // センサー1フラグ
int Sen2_flg = 0;                                                   // センサー2フラグ
int Rom_Gain = 0;                                                   // ゲイン値(EEPROM保存値)
int Rom_Light = 0;                                                  // 常点灯値(EEPROM保存値)
int Acc_rate = 5;                                                   // 加速周期時間
int Dec_rate = 5;                                                   // 減速周期時間
int Stop_time = 5000;                                               // 停車時間(5s)
int Slice_level = 716;                                              // プッシュスイッチ、センサーのHi/Lowスライスレベル(ADCポートのため)
int FB_int = 1;                                                     // フィードバック割り込みフラグ
int Gmode = 2;                                                      // ゲインモード

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          SetUP INIT            \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void setup() {
  lcd.begin(16,2);                                                  // LCD表示範囲指定
  lcd.clear();                                                      // LCDクリアー
  //Serial.begin(9600);                                             // シリアルの設定
  pinMode(LED_Blue, OUTPUT);                                        // 各ポート設定
  pinMode(PWM_OUT1, OUTPUT);
  pinMode(PWM_OUT2, OUTPUT);
  pinMode(SW_FOR, INPUT);
  pinMode(SW_REV, INPUT);
  pinMode(INT_PWM1, INPUT_PULLUP);
  pinMode(INT_PWM2, INPUT_PULLUP);
  attachInterrupt(0,int_FOR, RISING);
  attachInterrupt(1,int_REV, RISING);
  pinMode(LCD_BKL, OUTPUT);
  digitalWrite(LCD_BKL, LOW);

  lcd.setCursor(0,0);                                                 //　オープニング画面
  lcd.print("P'sTec   Arduino");                                      //
  lcd.setCursor(2,1);                                                 //
  lcd.print("Soft by Higuma");                                        //
  
  delay(3000);                                                        // ディレイ3s

  Rom_Gain = EEPROM.read(0);                                          // Gain値をEEPOMの(0)から読み出し
  if(Rom_Gain >= 11){                                                 // Gain値が11以上なら(設定させていない時の処理)
    EEPROM.write(0, 5);                                               // Gain値をEEPROMに保存(0-10)
    Rom_Gain = 5;                                                     // Gain値を"5"にする
  }
  Rom_Light = EEPROM.read(1);                                         // 常点灯値をEEPROMの(1)から読み出し
  if(Rom_Light >= 255){                                               // 常点灯値が255以上なら
    EEPROM.write(1,0);                                                // 常点灯値をEEPROMに保存(0-255)
    Rom_Light = 0;                                                    // 常点灯値を"0"にする
  }
  Gmode = EEPROM.read(2);                                             // ゲインモードをEEPOMの(2)から読み出し
  if(Gmode >= 13){                                                    // ゲインモードが13以上なら(設定させていない時の処理)
    EEPROM.write(2, 6);                                               // ゲインモード値をEEPROMに保存(1,2,4)
    Gmode = 2;                                                        // ゲインモードを"2"にする
    }

  lcd.clear();                                                        // LCDクリアー
  lcd.setCursor(0,0);                                                 // カーソルを1行目1文字目
  lcd.print("Vol");                                                   // "Vol"LCD表示
  lcd.setCursor(9,1);                                                 // カーソルを2行目10文字目
  lcd.print("FB");                                                    // "FB"LCD表示
  lcd.setCursor(0,1);                                                 // カーソルを2行目1文字目
  lcd.print("Out");                                                   // "Out"LCD表示
  lcd.setCursor(9,0);                                                 // カーソルを1行目10文字目
  if(Gmode == 2){                                                     // ゲインモードが"2"(Nolmal)なら
    lcd.print(" N");                                                  // "N"を表示
  }
  else if(Gmode == 1){                                                // ゲインモードが"1"(Coreless)なら
    lcd.print(" C");                                                  // "C"を表示
  }
  else{
    lcd.print(" S");                                                  // その他("4")なら"S"(Slow)を表示
  }
}

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          MAIN LOOP             \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/

void loop() {
    detachInterrupt(0);                                               // 割り込み0停止
    detachInterrupt(1);                                               // 割り込み1停止

    val = analogRead(Volume);                                         // Volume入力読み込み Max 1024
    if(val >= 1000){
      val = 1000;
    }
    Sen1 = analogRead(Sensor_1);                                      // Sensor_1入力読み込み Max1024
    Sen2 = analogRead(Sensor_2);                                      // Sensor_2入力読み込み Max1024
  
    if( analogRead(PushSW) <= 512){                                   // PushSWが押されたら。。。
      if( digitalRead(SW_FOR) == 0 || digitalRead(SW_REV) == 0){      // SW_FORかSW_REVになったいたら。。。
        Light_on_set();                                               // 常時点灯の設定へ。。。
      }
      if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){      // SW_STOPになっていたら。。。
        Gain_set();                                                   // ゲインの設定へ。。。
      }
    }
    
    Sensor_on();                                                      // Sensor入力確認
    
    attachInterrupt(0,int_FOR, RISING);                               // FOR側フィードバック割り込み開始
    attachInterrupt(1,int_REV, RISING);                               // REV側フィードバック割り込み開始
    
    //Serial.print(FB_Read);                                          // シリアル出力

    // 方向SW読み込み
    if(auto_d == 0){                                                  // auto_dフラグが0の時は。。。
      if( digitalRead(SW_FOR) == 0){ Dig = 0; }                       // SW_FORになっていたらDigは"0"にする
      if( digitalRead(SW_REV) == 0){ Dig = 1; }                       // SW_REVになっていたらDigは"1"にする
    }
    if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){        //  SW_STOPになっていたらDigは"2"にする
      Dig = 2;
      auto_d = 0;                                                     // auto_dフラグは"0"にする(Manualにする)
      sen_flg = 0;                                                    // Sensor検出フラグクリアー
      FB_int = 1;
    }
    if(FB_int == 1){                                                  //　フィードバック割り込みフラグが"1"なら(割り込み直後か?)
      //digitalWrite(LED_Blue,HIGH);                                  // タイミングチェック用(オシロでチェック)
           
      // フィードバック  PWM出力
      if((val - FB_Read * Gmode) >= 0){                               // Volume値がFeedbak値x8より大きい時
        val_fb = val_fb + Rom_Gain;                                   // フィードバック累積値(val_fb)を増やして速度を上げる
      }
      if((val - FB_Read * Gmode) <= 0){                               // Volume値がFeedbak値x8より小さい時
        val_fb = val_fb - Rom_Gain*4;                                 // フィードバック累積値(val_fb)を減らして速度を下げる
      }

      if(val_fb <= -1023){                                            // フィードバック値が最小値を超えたら。。。
        val_fb = -1023;                                               // 最小値とする
      }
      if(val_fb >= 1023){                                             // フィードバック値が最大値を超えたら。。。
        val_fb = 1023;                                                // 最大値とする
      }
      val_out = val + val_fb;                                         // PWMへの出力値を計算
      if(val_out <= 4){                                               // 出力値が"4"以下だったら。。。
        val_out = 4;                                                  // PWM出力は"4"を出力(最低"1"を出力しないと割り込みが掛らなくなる)
      }
      if(val_out >= 1023){                                            // 出力値が"1023"以上になったら。。。
        val_out = 1023;                                               // "1023"にする
      }
      FB_int = 0;                                                     // フィードバック割り込みフラグをクリアー
      //digitalWrite(LED_Blue,LOW);                                   // タイミングチェック用(オシロでチェック)
    }
    if(val <= 0){                                                     // Volume値が"0"になったら。。。
      val_fb = 0;                                                     // フィードバック累積値は"0"とする
      FB_int = 1;                                                     // フィードバック割り込みフラグ
      val_out = 0;                                                    // PWM出力値
    }
    
    if(Dig == 0){                                                     // Dig = 0(SW_FOR)の時は前進(PWM_OUT1)へ
      if(val <= 0){                                                   // ボリューム値が小さい(0)の時。。。
        analogWrite(PWM_OUT1, Rom_Light/4);                           // PWMを出力する
      }
      else{                                                           // 常時点灯よりボリューム値が大きい時。。。
        analogWrite(PWM_OUT1, val_out/4);                             // PWMを出力する
      }
    }
    else if(Dig == 1){                                                // Dig = 1(SW_REV)の時は後進(PWM_OUT2)へ
      if(val <= 0){                                                   // ボリューム値が小さい(0)の時。。
        analogWrite(PWM_OUT2, Rom_Light/4);                           // PWMを出力する
      }
      else{                                                           // 常時点灯よりボリューム値が大きい時。。。
        analogWrite(PWM_OUT2, val_out/4);                             // PWMを出力する
      }
    }
    else{                                                             // Dig = 2(SW_STOP)の時は停止へ
      analogWrite(PWM_OUT1, 0);                                       // PWMを停止へ
      analogWrite(PWM_OUT2, 0);                                       // PWMを停止へ
      val_fb = 0;                                                     // フィードバック累積値(val_fb)をリセット
      val_out = 0;                                                    // PWM出力データクリアー
      sen_flg == 0;                                                   // どのSensorを検出したかのフラグ "0"センサー未検出
    }

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Display LCD          \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
 
    lcd.setCursor(3,0);                                               // カーソルを1行目2文字目
    sprintf(buff, "%4d%%", val/10);                                   // Volume値
    lcd.print(buff);                                                  // 表示

    lcd.setCursor(3,1);                                               // カーソルを2行目2文字目
    sprintf(buff, "%4d%%", val_out/10);                               // PWM出力値
    lcd.print(buff);                                                  // 表示

    lcd.setCursor(12,1);                                              // カーソルを2行目11文字目
    sprintf(buff, "%3d%%", val_fb/10);                                // フィードバック値
    lcd.print(buff);                                                  // LCD表示

    if(auto_d == 0){                                                  // オートでなければ。。。(Auto_d = 0ならマニュアル)
      lcd.setCursor(12,0);                                            // カーソルを1行目12文字目
      if(Dig == 0){                                                   // 方向スイッチフラグがFront
        lcd.print(" FOR");                                            // LCD表示"FOR"
      }
      else if(Dig == 1){                                              // 方向スイッチフラグがReverse
        lcd.print(" REV");                                            // LCD表示"REV"
      }
      else{                                                           // 方向スイッチフラグがSTOP
        lcd.print("STOP");                                            // LCD表示"STOP"
        lcd.setCursor(9,0);                                           // カーソルを1行目8文字目
        if(Gmode == 2){                                               // ゲインモードが"2"(Nolmal)なら
          lcd.print(" N");                                            // "N"を表示
        }
        else if(Gmode == 1){                                          // ゲインモードが"1"(Coreless)なら
          lcd.print(" C");                                            // "C"を表示
        }
        else{
          lcd.print(" S");                                            // その他("4")なら"S"(Slow)を表示
        }
      }
    }
 
    delay(10);                                                         // Delay 10ms
}
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Gain Set             \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void Gain_set(){                                                      // Feedback Gain設定
    analogWrite(PWM_OUT1, 0);                                         // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                         // PWM_OUT2停止
    val_fb = 0;                                                       // Feedback値クリアー
    
    lcd.clear();                                                      // LCDクリアー

    lcd.setCursor(0,0);                                               // カーソルを1行目1文字目
    lcd.print("Gain Set (0-10)");                                     // "Gain Set"LCD表示

    Rom_Gain = EEPROM.read(0);                                        // EEPROMに保存してあるGain値を読み込み
    sprintf(buff,"Set%3d",Rom_Gain);
    lcd.setCursor(7,1);                                               // カーソルを2行目1文字目
    lcd.print(buff);                                                  // EEPROMに保存してあったGain値をLCD表示
    
    while( analogRead(PushSW) <= 512){                                // PushSWが離されるまでループ
    }                                                                 // analogRead Max1023(SW押下で"0")
    delay(100);                                                       // Delay 100ms
    while( analogRead(PushSW) >= 512){                                // PushSWが押下されるまでループ
                                                                      // analogRead Max1023(SW押下で"0")
      val = analogRead(Volume);                                       // Volume値読み込み analogRead Max 1023
      sprintf(buff,"%3d",val/100);                                    // Volume値を1/100としLCD表示用にする(max10)
      lcd.setCursor(13,1);                                            // カーソルを1行目12文字目
      lcd.print(buff);                                                // Volume値をLCDに表示

      if( digitalRead(SW_FOR) == 0){                                  // トグルスイッチが"Forward"なら
        Gmode = 4;                                                   // ゲインモードを"4"とする
        lcd.setCursor(0,1);                                           // カーソルを2行目1文字目
        lcd.print("Slow  ");                                          // "Slow"を表示(超低速走行用)
      }
      else if( digitalRead(SW_REV) == 0){                             // トグルスイッチが"Reverse"なら
        Gmode = 1;                                                    // ゲインモードを"1"とする
        lcd.setCursor(0,1);                                           // カーソルを2行目1文字目
        lcd.print("CoLess");                                          // "CoLess"を表示(Coreless Motor)
      }
      else{
        Gmode = 2;                                                    // ゲインモードを"2"とする
        lcd.setCursor(0,1);                                           // カーソルを2行目1文字目
        lcd.print("Nolmal");                                          // "Nolmal"を表示(通常モーター)
      }
      
    }                                                                 
      EEPROM.write(0, val/100);                                       // Gain値をEEPROMに保存(0-10)
      Rom_Gain = val/100;                                             // Gain値をRom_Gainにする
      EEPROM.write(2,Gmode);                                          // ゲインモードをEEPROMに保存(1,2,4)
      while( analogRead(PushSW) <= 512){                              // PushSWが離されるまでループ
      }                                                               // analogRead Max1023(SW押下で"0")

    if(val != 0){                                                     // valが0でないときは
      lcd.clear();                                                    // LCDクリアー
      lcd.setCursor(0,0);                                             // カーソルを1行目1文字目
      lcd.print("Please");                                            // "Please Volume MIN"LCD表示
      lcd.setCursor(0,1);                                             // カーソルを1行目1文字目
      lcd.print("  Minimum Volume");                                  // "Please Volume MIN"LCD表示
    }
    while(analogRead(Volume) > 0){                                    // Volumeが"0"になるまでループ
    }

    lcd.clear();                                                      // LCDクリアー
    lcd.setCursor(0,0);                                               // カーソルを1行目1文字目
    lcd.print("Vol");                                                 // "Vol"LCD表示
    lcd.setCursor(9,1);                                               // カーソルを1行目8文字目
    lcd.print("FB");                                                  // "FB"LCD表示
    lcd.setCursor(0,1);                                               // カーソルを2行目1文字目
    lcd.print("Out");                                                 // "Out"LCD表示
   
    lcd.setCursor(9,0);                                               // カーソルを1行目8文字目
    if(Gmode == 2){                                                   // ゲインモードが"2"(Nolmal)なら
      lcd.print(" N");                                                // "N"を表示
    }
    else if(Gmode == 1){                                              // ゲインモードが"1"(Coreless)なら
      lcd.print(" C");                                                // "C"を表示
    }
    else{
      lcd.print(" S");                                                // その他("4")なら"S"(Slow)を表示
    }
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Light On Set         \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
void Light_on_set(){                                                  // 常時点灯の設定
    analogWrite(PWM_OUT1, 0);                                         // PWM_OUT1停止
    analogWrite(PWM_OUT2, 0);                                         // PWM_OUT2停止
    val_fb = 0;                                                       // Feedback値クリアー
    
    lcd.clear();                                                      // LCDクリアー

    lcd.setCursor(0,0);                                               // カーソルを1行目1文字目
    lcd.print("Light On Set");                                        // "Light On Set"LCD表示

    Rom_Light = EEPROM.read(1);                                       // EEPROMに保存してある常時点灯値を読み込み
    lcd.setCursor(0,1);                                               // カーソルを2行目1文字目
    sprintf(buff,"Set%3d%%",Rom_Light/10);                            // EEPROMに保存された常点灯値を編集
    lcd.print(buff);                                                  // 編集された常点灯値を表示
    
    while( analogRead(PushSW) <= 512){                                // PushSWが離されるまでループ
    }                                                                 // analogRead Max1023(SW押下で"0")
    delay(100);                                                       // Delay 100ms
    while( analogRead(PushSW) >= 512){                                // PushSWが押下されるまでループ
                                                                      // analogRead Max1023(SW押下で"0")
      val = analogRead(Volume);                                       // Volume値読み込み analogRead Max 1023
      sprintf(buff,"%3d%%",val/40);                                   // Volume値を1/40としLCD表示用にする(max25)
      lcd.setCursor(12,1);                                            // カーソルを1行目11文字目
      lcd.print(buff);                                                // Volume値をLCDに表示
      
      if(Dig == 0){                                                   // 進行方向フラグfor"0"
        analogWrite(PWM_OUT1, val/16);                                // PWM_OUT1へ出力
      }
      else if(Dig == 1){                                              // 進行方向フラグRev"1"
        analogWrite(PWM_OUT2, val/16);                                // PWM_OUt2へ出力
      }
    }
    if(val >= 1016){                                                  // valが1016以上なら
      val = 1016;                                                     // 1016にする
    }
    EEPROM.write(1, val/4);                                         // ボリューム値をEEPROMに保存
    Rom_Light = val/4;
    while( analogRead(PushSW) <= 512){                              // PushSWが離されるまでループ 
    }   
    if(val != 0){                                                     // valが0でないときは                                                    
      lcd.clear();                                                    // LCDクリアー
      lcd.setCursor(0,0);                                             // カーソルを1行目1文字目
      lcd.print("Please");                                            // "Please Volume MIN"LCD表示
      lcd.setCursor(0,1);                                             // カーソルを1行目1文字目
      lcd.print("  Minimum Volume");                                  // "Please Volume MIN"LCD表示
    }
    while(analogRead(Volume) > 0){                                    // Volumeが"0"になるまでループ
    }

    lcd.clear();                                                      // LCDクリアー
    lcd.setCursor(0,0);                                               // カーソルを1行目1文字目
    lcd.print("Vol");                                                 // "Vol"LCD表示
    lcd.setCursor(9,1);                                               // カーソルを1行目8文字目
    lcd.print("FB");                                                  // "FB"LCD表示
    lcd.setCursor(0,1);                                               // カーソルを2行目1文字目
    lcd.print("Out");                                                 // "Out"LCD表示
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/      Auto Drive Sensor In      \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void Sensor_on(){                                                     // 往復自動運転　動作
                                                                      // 
    if(sen_flg !=1){                                                  // Sensor flgが1で無い時
      if(Sen1 >= Slice_level){                                        // Sensor1がHiの時(1023=5V) 716=3.5V
        Sen1_flg = 1;                                                 // Sen1_flgを1にする(Sensor1を一度読んだ事を表すフラグ)
      }
    }
    if(sen_flg !=2){                                                  // Sensor flgが2で無い時
      if(Sen2 >= Slice_level){                                        // Sensor2がHiの時(1023=5V) 716=3.5V
        Sen2_flg = 1;                                                 // Sen1_flgを2にする(Sensor2を一度読んだ事を表すフラグ)
      }
    }
    
    if(Sen1_flg == 1){                                                // Sensor1のフラグがSetさせている。。。(センサーか゛Hiになった)
      if(Sen1 <= Slice_level){                                        // Sensor1がLowの時(1023=5V) 716=3.5V 
        if(sen_flg != 1){                                             // Sensor flgが1で無い時
          sen_flg = 1;                                                // Sensor flgを1にする
          Auto_drv();                                                 // Auto_drivを処理する
          Sen1_flg = 0;                                               
        }
      }
    }
    if(Sen2_flg == 1){                                                // Sensor2のフラグがSetさせている。。。(センサーか゛Hiになった)
      if(Sen2 <= Slice_level){                                        // Sensor2がLowの時(1023=5V) 716=3.5V
        if(sen_flg != 2){                                             // Sensor flgが2で無い時
          sen_flg = 2;                                                // Sensor flgを2にする
          Auto_drv();                                                 // Auto_drivを処理する
          Sen2_flg = 0;                                               // Sensor2 flgをクリアーする
        }
      }
    }
}

void Auto_drv(){
    lcd.setCursor(12,0);                                              // カーソルを1行目12文字目
    lcd.print("AUTO");                                                // LCD表示"AUTO"        
    
    auto_d = 1;                                                       // auto drive flgをsetする

    lcd.setCursor(9,0);                                               // カーソルを1行目8文字目
    if(sen_flg == 0){                                                 // センサー未検出時
      lcd.print("  ");                                                // LCD表示クリアー
    }
    if(sen_flg == 1){                                                 // センサー1検出時
      lcd.print("S1");                                                // LCD表示"S1"
    }
    if(sen_flg == 2){                                                 // センサー2検出時
      lcd.print("S2");                                                // LCD表示"S2"
    }
    
    while(val_out > Rom_Light){                                       // PWM出力値が常点灯値より大きい場合
      if(Dig == 0){                                                   // 方向フラグが"0" Forの場合
        analogWrite(PWM_OUT1,val_out/4);                              // ボリューム値の1/4をFor方向に出力(常点灯設定値は最大25%)
      }
      if(Dig == 1){                                                   // 方向フラグが"1" Revの場合
        analogWrite(PWM_OUT2,val_out/4);                              // ボリューム値の1/4をRev方向に出力(常点灯設定値は最大25%) 
      }   
      
      // 減速処理
      val_out--;                                                      // PWM出力値を-1する
      val_fb = 0;                                                     // フィードバック値をクリアーする

      lcd.setCursor(3,1);                                             // カーソルを2行目2文字目
      sprintf(buff, "%4d", val_out/10);                               // PWM出力値
      lcd.print(buff);                                                // 表示

      lcd.setCursor(12,1);                                            // カーソルを2行目11文字目
      sprintf(buff, "%4d", val_fb/10);                                // フィードバック値
      lcd.print(buff);                                                // LCD表示

      delay(Dec_rate);                                                // ディレイ減速時間
    }
    delay(Stop_time);                                                 // 停車時間

    lcd.setCursor(3,0);                                               // カーソルを1行目2文字目
    sprintf(buff, "%4d", val/10);                                     // Volume値
    lcd.print(buff);                                                  // 表示

    // 停車中
    Dig = !Dig;                                                       // 進行方向反転
    
    analogWrite(PWM_OUT1, 0);                                         // PWMを停止へ
    analogWrite(PWM_OUT2, 0);                                         // PWMを停止へ

    // 加速処理
    Accel = Rom_Light;                                                // 加速初期値を設定
    val = analogRead(Volume);                                         // Volume入力読み込み Max 1024
    while(val > Accel){                                               // ボリューム値が加速初期値より小さい時にループ
      if(Dig == 0){                                                   // 方向フラグ"For"の時
        analogWrite(PWM_OUT1,Accel/4);                                // 加速初期値からボリューム値までForへPWM出力
      }
      if(Dig == 1){                                                   // 方向フラグ"Rev"の時
        analogWrite(PWM_OUT2,Accel/4);                                // 加速初期値からボリューム値までRevへPWM出力
      }   
      Accel++;
      val_out = Accel;                                                // PWM出力値を+1する

      lcd.setCursor(3,1);                                             // カーソルを2行目4文字目
      sprintf(buff, "%4d", val_out/10);                               // PWM出力値を編集
      lcd.print(buff);                                                // 表示

      lcd.setCursor(12,1);                                            // カーソルを2行目11文字目
      sprintf(buff, "%4d", val_fb/10);                                // フィードバック値を編集
      lcd.print(buff);                                                // LCD表示
       
      delay(Acc_rate);                                                // ディレイ加速時間
    }
}

 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/         Feedback Input         \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void int_FOR(){                                                       // For側の割り込み
  GainN = (val / 4);                                                  // ゲインはボリューム値の1/4とする(ループ回数)
    if(n >= GainN){                                                   // GainNがN回になったら以下FeedBack電圧の取り込み処理を行う
      digitalWrite(LED_Blue,HIGH);                                    // タイミング確認用(オシロで確認)
      delayMicroseconds(1600);                                        // ディレイ1600us(PWMの立ち上がりから1600us待つてFB電圧取り込み)
      FB_Read = analogRead(PWM_FB1);                                  // フィードバック電圧取り込み
      if(FB_Read <= 0){ FB_Read = 0; }                                // 取り込み電圧が"0"以下なら"0"とする
    
      digitalWrite(LED_Blue,LOW);                                     // タイミング確認用(オシロで確認)
      n = 0;                                                          // nをクリアー
      //FB = FB_Read;                                                 //　
      FB_int = 1;                                                     // フィードバック割り込みフラグをセット
    }
    n++;                                                              // n+1
}

void int_REV(){                                                       // Rev側の割り込み
  GainN = (val / 4);                                                  // ゲインはボリューム値の1/4とする(ループ回数)
    if(n >= GainN){                                                   // GainNがN回になったら以下FeedBack電圧の取り込み処理を行う
      digitalWrite(LED_Blue,HIGH);                                    // タイミング確認用(オシロで確認)
      delayMicroseconds(1600);                                        // ディレイ1600us(PWMの立ち上がりから1600us待つてFB電圧取り込み)
      FB_Read = analogRead(PWM_FB2);                                  // フィードバック電圧取り込み
      if(FB_Read <= 0){ FB_Read = 0; }                                // 取り込み電圧が"0"以下なら"0"とする
    
      digitalWrite(LED_Blue,LOW);                                     // タイミング確認用(オシロで確認)
      n = 0;                                                          // nをクリアー
      //FB = FB_Read;                                                 //
      FB_int = 1;                                                     // フィードバック割り込みフラグをセット
    }
    n++;                                                              // n+1
}
