// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                                      P'sTec Higuma
//              Ardino UNO Power Pack Soft
//                  Non-Feedback    
//                  Non-Auto
//                                      2020/3/30
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
//                          Rev.0.0
//    Port Set
//      D0    LED_Blue                AD0   Volume
//      D1    LCD_RS                  AD1   PWM_FB1
//      D2    INT_PWM1                AD2   PWM_FB2
//      D3    INT_PWM2                AD3   Sensor_1
//      D4    SW_FOR                  AD4   Sensor_2
//      D5    SW_REV                  AD5   PushSW
//      D6    LCD_E
//      D7    LCD_BKL
//      D8    LCD_D4
//      D9    PWM_OUT1
//      D10   PWM_OUT2
//      D11   LCD_D5
//      D12   LCD_D6
//      D13   LCD_D7

#include <LiquidCrystal.h>
#include <EEPROM.h>

LiquidCrystal lcd(1, 6, 8, 11, 12, 13);      //　LCDポート設定

int LED_Blue = 0;                                                     // Blue LED出力ピン
int INT_PWM1 = 2;                                                     // PWM1割り込み入力ピン
int INT_PWM2 = 3;                                                     // PWM2割り込み入力ピン
int SW_FOR = 4;                                                       // SW_FOR入力ピン
int SW_REV = 5;                                                       // SW_REV入力ピン
int PWM_OUT1 = 9;                                                     // PWM_OUT1(For方向)出力ピン
int PWM_OUT2 = 10;                                                    // PWM_OUT2(Rev方向)出力ピン
int LCD_BKL = 7;                                                      // LCD_BKL出力ピン
int Volume = 0;                                                       // ボリューム　アナログ入力ピン
int PWM_FB1 = 1;                                                      // PWMフィードバック1　アナログ入力ピン
int PWM_FB2 = 2;                                                      // PWMフィードバック2　アナログ入力ピン
int Sensor_1 = 3;                                                     // Sensor1 アナログ入力ピン
int Sensor_2 = 4;                                                     // Sensor2 アナログ入力ピン
int PushSW = 5;                                                       // PushSW　アナログ入力ピン

int val = 0;                                                          // ボリューム読み込み値
char buff[16];                                                        // 変数 LCD表示文字
volatile int state = RISING;
int Dig = 2;                                                          // 進行方向フラグ
int Sen1 = 0;                                                         // センサー1フラグ
int Sen2 = 0;                                                         // センサー2フラグ
int Rom_Light = 0;                                                    // 常点灯値(EEPROM保存値)

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          SetUP INIT            \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/

void setup() {
  lcd.begin(16,2);                                                    // LCD表示範囲指定
  lcd.clear();                                                        // LCDクリアー
  //Serial.begin(9600);                                               // シリアルの設定
  pinMode(LED_Blue, OUTPUT);
  pinMode(PWM_OUT1, OUTPUT);
  pinMode(PWM_OUT2, OUTPUT);
  pinMode(SW_FOR, INPUT);
  pinMode(SW_REV, INPUT);
  pinMode(INT_PWM1, INPUT_PULLUP);
  pinMode(INT_PWM2, INPUT_PULLUP);
  pinMode(LCD_BKL, OUTPUT);
  digitalWrite(LCD_BKL, LOW);

  lcd.setCursor(0,0);                                                 //　オープニング画面
  lcd.print("P'sTec   Arduino");                                      //
  lcd.setCursor(2,1);                                                 //
  lcd.print("Soft by Higuma");                                        //
  
  delay(3000);                                                        // ディレイ3s
  
  lcd.clear();                                                        // LCDクリアー
      
  Rom_Light = EEPROM.read(1);                                         // 常点灯値をEEPROMの(1)から読み出し
  if(Rom_Light >= 255){                                               // 常点灯値が255以上なら
    EEPROM.write(1,0);                                                // 常点灯値をEEPROMに保存(0-255)
    Rom_Light = 0;                                                    // 常点灯値を"0"にする
  }
}

// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
// \**/\**/          MAIN LOOP             \**/\**/                    
// \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/

void loop() {
    val = analogRead(Volume);                                         // Volume入力読み込み Max 1024

    if( analogRead(PushSW) <= 512){                                   // PushSWが押されたら。。。
    //    Light_on_set();                                             // 常時点灯の設定へ。。。
    }

    //Serial.print(FB_Read);                                          // シリアル出力

    // 方向SW読み込み
    if( digitalRead(SW_FOR) == 0){ Dig = 0; }                         // SW_FORになっていたらDigは"0"にする
    if( digitalRead(SW_REV) == 0){ Dig = 1; }                         // SW_REVになっていたらDigは"1"にする
    if( digitalRead(SW_FOR) == 1 && digitalRead(SW_REV) == 1){        // SW_STOPになっていたらDigは"2"にする
        Dig = 2;
    }
    
    //int Rom_Light = EEPROM.read(1);                                 // EEPROM(1)から常時点灯の保存値を読み込み
    
    // PWM出力
    if(Dig == 0){                                                     // Dig = 0(SW_FOR)の時は前進(PWM_OUT1)へ
      if(val <= Rom_Light){                                           // ボリューム値が小さい(0)の時。。。
        analogWrite(PWM_OUT1, Rom_Light/4);                           // PWMを出力する
      }
      else{                                                           // 常時点灯よりボリューム値が大きい時。。。
        analogWrite(PWM_OUT1, val/4);                                 // PWMを出力する
      }
    }
    else if(Dig == 1){                                                // Dig = 1(SW_REV)の時は後進(PWM_OUT2)へ
      if(val <= Rom_Light){                                           // ボリューム値が小さい(0)の時。。
        analogWrite(PWM_OUT2, Rom_Light/4);                           // PWMを出力する
      }
      else{                                                           // 常時点灯よりボリューム値が大きい時。。。
        analogWrite(PWM_OUT2, val/4);                                 // PWMを出力する
      }
    }
    else{                                                             // Dig = 2(SW_STOP)の時は停止へ
      analogWrite(PWM_OUT1, 0);                                       // PWMを停止へ
      analogWrite(PWM_OUT2, 0);                                       // PWMを停止へ
    }
    if(analogRead(PushSW) <= 512){
      while( analogRead(PushSW) <= 512){                              // PushSWが離されるまでループ
          val = analogRead(Volume);                                   // Volume入力読み込み Max 1024 
          lcd.setCursor(5,1);                                         // カーソルを1行目2文字目
          sprintf(buff, "%3d%%", val/40);                             // Volume値
          lcd.print(buff);                                            // 表示

          if(Dig == 0){                                               // 進行方向フラグfor"0"
          analogWrite(PWM_OUT1, val/40);                              // PWM_OUT1へ出力
          }
          else if(Dig == 1){                                          // 進行方向フラグRev"1"
          analogWrite(PWM_OUT2, val/40);                              // PWM_OUt2へ出力
        }
      }                                                               
      if(val >= 1016){                                                // valが1016以上なら
        val = 1016;                                                   // 1016にする
      }
      EEPROM.write(1, val/4);                                         // 1/4ボリューム値をEEPROMに保存
      Rom_Light = val/4;                                              // 常点灯値に1/4ボリューム値を代入

      if(val != 0){                                                   // valが0でないときは                                                    
        lcd.clear();                                                  // LCDクリアー
        lcd.setCursor(0,0);                                           // カーソルを1行目1文字目
        lcd.print("Set Volume MIN");                                  // "Set Volume MIN"LCD表示
      }
    while(analogRead(Volume) > 0){                                    // Volumeが"0"になるまでループ
    }
    lcd.clear();                                                      // LCDクリアー  
    }

 
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/\**/
 // \**/\**/           Display LCD          \**/\**/
 // \**/\**/\**/\**/\**/\**/\**/\**/\**/ HiGuma \**/
 
    lcd.setCursor(0,0);                                               // カーソルを1行目2文字目
    sprintf(buff, "Vol%3d%%", val/10);                                // Volume値
    lcd.print(buff);                                                  // 表示

    lcd.setCursor(9,0);                                               // カーソルを1行目12文字目
      if(Dig == 0){                                                   // 方向スイッチフラグがFront
        lcd.print("Forward");                                         // LCD表示"FOR"
    }
    else if(Dig == 1){                                                // 方向スイッチフラグがReverse
      lcd.print("Reverse");                                           // LCD表示"REV"
    }
    else{                                                             // 方向スイッチフラグがSTOP
      lcd.print("   Stop");                                           // LCD表示"STP"
    }

    //if(Rom_Light != 0){                                             // EEPROMに保存してある常時点灯値を読み込み
        sprintf(buff,"Light%3d%%",Rom_Light/10);
        lcd.setCursor(0,1);
        lcd.print(buff);
    //}
    delay(100);                                                       // Delay 100ms
}
