/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include <device.h>
#include <stdio.h>
#include <stdlib.h>

#define MOTOR_HIGH 4096                                        // モーター出力最大値
#define MOTOR_LOW 0                                            // モーター出力最小値
#define AUTO_SENSOR_PIN_MAX 2                                  // 自動運転のセンサーピンの期待するピンの数
// ポイントの数
#define POINT_SET_MAX 2

struct VehicleData {                                           // 車両の設定値用構造体
    uint16 flat;                                               // 平坦時の出力％
    uint16 station;                                            // 駅手前の出力％
    uint16 stop;                                               // 停止時の出力％
    uint16 station_chang_ms;                                   // 駅手前の変速開始までの待ち時間ms
    uint16 chang_up_ms_flat_mode;                              // 平坦のスピードにアップする時間ms
    uint16 chang_up_ms_station_mode;                           // 駅手前のスピードにアップする時間ms
    uint16 chang_down_ms_flat_mode;                            // 平坦のスピードにダウンする時間ms
    uint16 chang_down_ms_station_mode;                         // 駅手前のスピードにダウンする時間ms
    uint16 chang_stop_ms;                                      // 停止までの時間ms
    uint16 restartms;                                          // 再発進までの時間ms
    uint16 chang_restart_ms;                                   // 再発車して一定の速度になるまでの時間ms
};
struct VehicleData Vehicle;                                    // 車両の設定値構造体

enum {                                                         // 動作モード
    Manual_DRIVE = 0,                                          // 手動運転
    Auto_check,                                                // 自動運転開始設定
    Auto_DRIVE,                                                // 自動運転
    Mode_End                                                   // 選択終わり位置用
};

enum {                                                         // 速度モード
    Speed_Flat = 0,                                            // 平坦
    Speed_Stop,                                                // 停止
    Speed_Pause,                                               // 停車中
    Speed_Restart,                                             // 再発進
    Speed_Station,                                             // 駅手前
    Speed_Station_keep,                                        // 駅手前速度保持
    Speed_no_change                                            // 速度変更無し
};

extern int8 Sensor_in_1;                                       // センサー1の出力値
extern int8 Sensor_in_2;                                       // センサー2の出力値

extern uint16 operation_mode;                                  // 動作モード 0=手動運転 / 1=自動運転開始設定 / 2=自動運転開始設定 / 3=自動運転 / 4=選択終わり位置用

extern float motor_val_f;                                      // 速度変更用

extern uint16 motor_val;                                       // モータの値

extern uint8 motor_dir_ini;                                    // モータの回転方向の初期値 0=負/1=正/255=停止
extern int power_pack_volume;                                  // パワーパックからのボリューム入力値
extern uint timer_100us_start;                                 // 100usのTimer動作開始 0=停止/1=開始
extern uint16 speed_mode;                                      // 速度モード 0=上り / 1=平坦 / 2=下り
extern int16 speed_set_forced_termination;                     // 現在の速度設定強制終了フラグ 0=しない/1=する
extern uint16 motor_stop_val;                                  // 停止時のモータ出力値(常時点灯)
extern int motor_val_add;                                      // 出力補正用の加減算値
extern uint16 auto_sleeptimer_1ms;                             // 1ms timer
extern int32 timer_1ms;                                        // 1ms timer
extern uint8 point_no_state_ini[POINT_SET_MAX];                // ポイントの状態の初期値 0=逆側 / 1=正側
extern uint8 point_no_state[POINT_SET_MAX];                    // ポイントの状態         0=逆側 / 1=正側
extern uint8 motor_dir;                                        // モータの回転方向の初期値 0=負/1=正/255=停止
extern int i;
extern uint8 forward_backward_mode_keep;                       // パワーパックからの前後切り替えモード 1=前進/2=後退/3=停止
extern uint16 speed_chang_mode;                                // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
extern uint volume_flg;                                        // 速度ボリューム絞って停止の判定フラグ
extern int pp_vol;                                             // パワーパックからのボリューム入力値
extern int power_pack_keep_volume;                             // パワーパックからのボリューム値記憶用
extern int flash_led_zero;                                     // 室内灯常時点灯用(車両毎に常時点灯する出力がが異なるので、計測して保存する))

void mainbord_sw_chk(void);                                    // メインボードＳＷチェック処理

void auto_drive_1ms(void);                                     // 自動運転1ms毎のタイマー割り込み処理
void auto_drive_100us(void);                                   // 自動運転100us毎のタイマー割り込み処理
void auto_drive_ini(int ope_mode);                             // 自動運転初期化処理
void auto_drive_sub(void);                                     // 自動運転処理
void auto_sensor_chk(void);                                    // 自動運転センサーチェック処理
void auto_sleep_ms(uint16 wait_ms);                            // タイマーを使ったスリープ処理

void sensor_sw_chk(void);                                      // センサーＳＷチェック処理
void lcd_disp(uint8 row, uint8 column, char *data);
void stop_setting(void);                                       //    停止の設定実施
void restart_setting(void);                                    //    再発進の設定実施
void restart_setting2(void);                                   //    再発進の設定実施2
void bf_tbl_chk(void);                                         // フィードバックテーブルの位置チェック
void lcd_vol_fb_out_disp();                                    //  LCD表示。ボリューム値、フィードバック値、出力値の表示



/* [] END OF FILE */
