/* ========================================
 *
 * Copyright YOUR COMPANY, THE YEAR
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF your company.
 *
 * ========================================
*/
#include "auto_func.h"

uint16 operation_mode = Manual_DRIVE;                          // 動作モード 0=手動運転 / 1=自動運転開始設定 / 2=自動運転開始設定 / 3=自動運転 / 4=選択終わり位置用

uint16 auto_sleeptimer_1ms = 0;                                // 1ms timer
uint8 auto_timer_1_StartStop = 0;                              // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
int32 push_sw_timer_1ms = 0;                                   // プッシュSW 1ms timer
int8  push_sw_timer_start = 0;                                 // プッシュSWタイマー開始

float add_val_f;                                               // 速度変更用の加算値
float power_pack_volume_f;                                     // 速度変更用
int power_pack_volume_keep = 0;                                // パワーパックのボリューム入力値保存用

uint16 target_val;                                             // 速度変更目標値

uint16 kitai_intr_val[AUTO_SENSOR_PIN_MAX] ={1,2};             // 期待している割り込み番号
uint16 kitai_intr_cnt = 0;                                     // 期待している割り込みの位置用
int8   keep_auto_Sensor_in_1 = -1;                             // 自動用センサー1の前回出力値
int8   keep_auto_Sensor_in_2 = -1;                             // 自動用センサー2の前回出力値

// **********************************
// 速度変更処理
// **********************************
void chang_speed(uint16 set_val,uint16 chg_mode) {
    uint16 change_time;

    target_val = (float)power_pack_volume_keep / (float)100 * (float)set_val;            // 目標速度(モータの出力値。0～2400)へ変換。
//    timer_100us_start = 1;                                     // 100usタイマ開始

    power_pack_volume_f = (float)power_pack_volume;
    if (power_pack_volume < target_val) {                              // 速度アップ
        if (chg_mode == Speed_Restart) {                       // 再発車モードが選択されていたら
            change_time = Vehicle.chang_restart_ms;            // 再発車して一定の速度になるまでの時間ms
        } else if (chg_mode == Speed_Station) {                // 駅手前モードが選択されていたら
            change_time = Vehicle.chang_up_ms_station_mode;    // 駅手前のスピードにアップする時間ms
        } else {                                               // その他のモードが選択されていたら
            change_time = Vehicle.chang_up_ms_flat_mode;       // 平坦のスピードにアップする時間ms
        }
        speed_chang_mode = 1;                                  // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
        add_val_f = (float)(((float)target_val - (float)power_pack_volume) / (float)change_time); 
        auto_timer_1_StartStop = 1;                            // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
    }
    else if (power_pack_volume > target_val) {                         // 速度ダウン
        if (chg_mode == Speed_Station) {                       // 駅手前モードが選択されていたら
            change_time = Vehicle.chang_down_ms_station_mode;  // 駅手前のスピードにダウンする時間ms
        } else {
            change_time = Vehicle.chang_down_ms_flat_mode;     // 平坦のスピードにダウンする時間ms
        }
        speed_chang_mode = 2;                                  // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
        add_val_f = (float)(((float)power_pack_volume - (float)target_val) / (float)change_time); 
        auto_timer_1_StartStop = 1;                            // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
    }
    else {
        speed_chang_mode = 0;                                  // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
        speed_mode = Speed_no_change;                          // 速度モードを速度一定に遷移。
        return;
    }
    // 無限ループに入る前に強制終了フラグをクリアしておく。
    speed_set_forced_termination = 0;                          // 現在の速度設定強制終了フラグ 0=しない/1=する
    // 速度が変わり終わるまで、無限ループで待つ。
    while (1) {
        bf_tbl_chk();                                          // フィードバックテーブルの位置チェック
        lcd_vol_fb_out_disp();                                 //  LCD表示。ボリューム値、フィードバック値、出力値の表示

        // 速度が変わり終わったら
        if (speed_chang_mode == 0) {                           // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            if (chg_mode == Speed_Station) {                   // 駅手前モードが選択されていたら
                speed_mode = Speed_Station_keep;               // 速度モードを駅手前速度保持に遷移。
            }else{
                speed_mode = Speed_no_change;                  // 速度モードを速度一定に遷移。
            }
            break;                                             // 変速終了、メインルーチンに戻る。
        }
        // 変速中に別の速度になったら
        if (speed_set_forced_termination == 1) {               // 現在の速度設定強制終了フラグ 0=しない/1=する
            speed_chang_mode = 0;                              // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            auto_timer_1_StartStop = 0;                        // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            break;                                             // メインルーチンに戻って、再度変速を開始する。
        }
    }
}

// **********************************
// 自動運転再スタート初期化処理
// **********************************
void auto_restart_ini(void) {
    motor_val_add = 0;                                         // 補正値をクリア
    volume_flg = 0;                                            // 停止時にフラグをクリア
//    timer_100us_start = 0;                                     // 100usタイマ停止
    pwm_WriteCompare(5);                                       // 発進用の値を出力し発進！
}

// **********************************
// 速度停止処理
// **********************************
void chang_stop_speed(void) {
    target_val = Vehicle.stop;                                  // 目標速度(モータの出力値。)へ変換。
    power_pack_volume_f = (float)power_pack_volume;
    if (power_pack_volume > target_val) {                       // 速度ダウン
        speed_chang_mode = 2;                                   // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
        add_val_f = (float)(((float)power_pack_volume - (float)target_val) / (float)Vehicle.chang_stop_ms); 
        auto_timer_1_StartStop = 1;                            // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
    }
    else {
        speed_chang_mode = 0;                                  // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
        speed_mode = Speed_no_change;                          // 速度モードを速度一定に遷移。
        return;
    }
    // 無限ループに入る前に強制終了フラグをクリアしておく。
    speed_set_forced_termination = 0;                          // 現在の速度設定強制終了フラグ 0=しない/1=する
    // 速度が変わり終わるまで、無限ループで待つ。
    while (1) {
        bf_tbl_chk();                                          // フィードバックテーブルの位置チェック
        lcd_vol_fb_out_disp();                                 //  LCD表示。ボリューム値、フィードバック値、出力値の表示

        // 速度が変わり終わったら
        if (speed_chang_mode == 0) {                           // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            auto_restart_ini();                                // 自動運転再スタート初期化処理
            power_pack_volume = 0;                             // 停止時の出力0にする
            stop_setting();                                    // 停止の設定実施
            speed_mode = Speed_Pause;                          // 速度モードを停車中に遷移。
            auto_sleep_ms(200);                                // タイマーを使ったスリープ処理
           break;                                              // 変速終了、メインルーチンに戻る。
        }
        // 変速中に別の速度になったら
        if (speed_set_forced_termination == 1) {               // 現在の速度設定強制終了フラグ 0=しない/1=する
            speed_chang_mode = 0;                              // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            auto_timer_1_StartStop = 0;                        // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            break;                                             // メインルーチンに戻って、再度変速を開始する。
        }
    }
}

// **********************************
// 再発進処理
// **********************************
void chang_restart_speed(void) {
    speed_chang_mode = 0;                                      // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
    timer_1ms = 0;                                             // 1ms timer
    auto_timer_1_StartStop = 0;                                // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
    // 無限ループに入る前に強制終了フラグをクリアしておく。
    speed_set_forced_termination = 0;                          // 現在の速度設定強制終了フラグ 0=しない/1=する
    // 指定時間まで停止し終わるまで、無限ループで待つ。
    while (1) {
        bf_tbl_chk();                                          // フィードバックテーブルの位置チェック
        lcd_vol_fb_out_disp();                                 //  LCD表示。ボリューム値、フィードバック値、出力値の表示

        // 停止時間分待つ
        if (timer_1ms >= Vehicle.restartms) {
            speed_mode = Speed_Restart;                        // 速度モードを再発進に遷移。
            break;
        }
        // 停止中に別の速度になったら
        if (speed_set_forced_termination == 1) {               // 現在の速度設定強制終了フラグ 0=しない/1=する
            speed_chang_mode = 0;                              // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            auto_timer_1_StartStop = 0;                        // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            break;                                             // メインルーチンに戻って、再度変速を開始する。
        }
    }
}

// ****************************
//  自動運転1ms毎のタイマー割り込み処理
// ****************************
void auto_drive_1ms(void) {
    timer_1ms++;
    auto_sleeptimer_1ms++;
    if (auto_timer_1_StartStop == 1) {                         // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
        if (speed_chang_mode == 1) {                           // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            power_pack_volume_f = power_pack_volume_f + add_val_f;
            power_pack_volume = power_pack_volume_f;
            if (power_pack_volume >= target_val) {                     // 速度が目標値になったら
                power_pack_volume = target_val;                        // 速度が目標値になった
                speed_chang_mode = 0;                          // スピード変更フラグ 0=変更なし/1=変更する
                auto_timer_1_StartStop = 0;                    // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            }
        }
        else if (speed_chang_mode == 2) {                      // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            power_pack_volume_f = power_pack_volume_f - add_val_f;
            power_pack_volume = power_pack_volume_f;
            if (power_pack_volume <= target_val) {                     // 速度が目標値になったら
                power_pack_volume = target_val;                        // 速度が目標値になった
                speed_chang_mode = 0;                          // スピード変更フラグ 0=変更なし/1=変更する
                auto_timer_1_StartStop = 0;                    // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            }
        }
    }
}

// ****************************
// 自動運転100us毎のタイマー割り込み処理(常に100us毎に入ってくる割り込み)
// ****************************
void auto_drive_100us(void) {
}

// ****************************
//  自動運転初期化処理
// ****************************
void auto_drive_ini(int ope_mode) {
    if (ope_mode == Auto_check) {
        // 車両 1台の時のデフォルト値
        Vehicle.flat = 100;                                     // 平坦時の出力％
        Vehicle.station = 50;                                   // 駅手前の出力％
        Vehicle.stop = 0;                                       // 停止時の出力％
        Vehicle.station_chang_ms = 500;                         // 駅手前の変速開始までの待ち時間ms
        Vehicle.chang_up_ms_flat_mode = 8000;                   // 平坦のスピードにアップする時間ms
        Vehicle.chang_up_ms_station_mode = 4000;                // 駅手前のスピードにアップする時間ms
        Vehicle.chang_down_ms_flat_mode = 4000;                 // 平坦のスピードにダウンする時間ms
        Vehicle.chang_down_ms_station_mode = 3000;              // 駅手前のスピードにダウンする時間ms
        Vehicle.chang_stop_ms = 2000;                           // 停止までの時間ms
        Vehicle.restartms = 10000;                              // 再発進までの時間ms
        Vehicle.chang_restart_ms = 3000;                        // 再発車して一定の速度になるまでの時間ms
        operation_mode = Auto_check;                            // 自動運転開始設定
    }
    else if (ope_mode == Manual_DRIVE) {
        operation_mode = Manual_DRIVE;                          // 手動運転開始設定
    }
}

// ********************************************************
// 全ポイント切り替え
// ********************************************************
void all_point_change(void) {
    P34_Point1_Write(point_no_state[0]);                       // ポイント1切り替え
    P35_Point2_Write(point_no_state[1]);                       // ポイント2切り替え
}

// ****************************
//  自動運転処理
// ****************************
void auto_drive_sub(void) {
    int16 i = 0;
    
    switch(operation_mode) {
        case Manual_DRIVE:                                     // 手動運転
            // 何もしない
            break;
        case Auto_check:                                       // 自動運転開始設定
            operation_mode = Auto_DRIVE;                       // 動作モードを自動運転モードに遷移する。
            speed_set_forced_termination = 0;                  // 現在の速度設定強制終了フラグ 0=しない/1=する
            speed_mode = Speed_Flat;                           // 速度モード 1=平坦
            kitai_intr_cnt = 0;                                // 期待している割り込みの位置用
            keep_auto_Sensor_in_1 = -1;                        // 自動用センサー1の前回出力値
            keep_auto_Sensor_in_2 = -1;                        // 自動用センサー2の前回出力値
            motor_dir = motor_dir_ini;                         // 進行方向を初期値に戻す。
            point_no_state_ini[0] = 0;                         // ポイントの状態の初期値 0=逆側 / 1=正側
            point_no_state_ini[1] = 0;                         // ポイントの状態の初期値 0=逆側 / 1=正側
            dig_dir_Write(motor_dir);                          // モータの回転方向 0=負/1=正
            // ポイントを初期状態にする
            for (i=0;i<POINT_SET_MAX;i++) {                    // ポイントの数分繰り返す
                // ポイント初期状態をセット(ポイント切り替えは現在値の反対にするので、初期値を反対にする。)
                point_no_state[i] = (point_no_state_ini[i] + 1) & 0x01; // ポイント方向切換 0=逆回転 / 1=正回転
            }
            // ポイントを一度開始方向にして、次に反対にして、再度開始方向にする。
            all_point_change();                                // 全ポイント切り替え
            stop_setting();                                    // 停止の設定実施
            restart_setting();                                 // 再発進の設定実施
            restart_setting2();                                // 再発進の設定実施2
            power_pack_volume = ADC_SAR_Seq_1_GetResult16(0)*2;
            power_pack_volume_keep = power_pack_volume;        // パワーパックのボリューム入力値保存用
            motor_val=power_pack_volume_keep;
            pwm_WriteCompare((uint16)motor_val);
            break;
        case Auto_DRIVE:                                       // 自動運転モード
            switch(speed_mode) {
                case Speed_Flat:                               // 平坦
                    chang_speed(Vehicle.flat,Speed_Flat);      // 平坦時の出力％へ変更
                    break;
                case Speed_Station:                            // 駅手前
                    timer_1ms = 0;
                    auto_timer_1_StartStop = 1;                // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
                    // 無限ループに入る前に強制終了フラグをクリアしておく。
                    speed_set_forced_termination = 0;          // 現在の速度設定強制終了フラグ 0=しない/1=する
                    while(1) {
                        // 駅手前の変速開始までの待ち時間が過ぎたら
                        if (timer_1ms >= Vehicle.station_chang_ms) { // "駅手前の変速開始までの待ち時間ms
                            break;
                        }
                        // 変速中に別の速度になったら
                        if (speed_set_forced_termination == 1) { // 現在の速度設定強制終了フラグ 0=しない/1=する
                            speed_chang_mode = 0;              // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
                            break;
                        }
                    }
                    auto_timer_1_StartStop = 0;                // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
                    if (speed_set_forced_termination == 0) {   // 現在の速度設定強制終了フラグ 0=しない/1=する
                        chang_speed(Vehicle.station,Speed_Station);// 駅手前の出力％へ変更
                    }
                    break;
                case Speed_Stop:                                // 停止
                    chang_stop_speed();                         // 停止。出力0へ
                    // ポイント切り替え
                    for (i=0;i<AUTO_SENSOR_PIN_MAX;i++) {       // ポイントの数分繰り返す
                        // ポイント初期状態をセット(ポイント切り替えは現在値の反対にするので、初期値を反対にする。)
                        point_no_state[i] = (point_no_state[i] + 1) & 0x01; // ポイント方向切換 0=逆回転 / 1=正回転
                    }
                    all_point_change();                         // 全ポイント切り替え
                    break;
                case Speed_Pause:                               // 停車中
                    chang_restart_speed();                      // 再発進。指定時間待ってから再発進へ
                    break;
                case Speed_Restart:                             // 再発進
                    auto_restart_ini();                         // 自動運転再スタート初期化処理
                    stop_setting();                             // 停止の設定実施
                    restart_setting();                          // 再発進の設定実施
                    restart_setting2();                         // 再発進の設定実施2
                    chang_speed(Vehicle.flat,Speed_Restart);    // 再発車して一定の速度になるまでの時間をかけて、平坦の出力％へ変更
                    break;
                case Speed_Station_keep:                        // 駅手前速度保持
                    // 駅手前速度を保持する制御をかけているので、パワーパックの入力を受け付けない
                    break;
                case Speed_no_change:                           // 速度変更無し
                    // パワーパックからのボリューム入力値を取得
                    power_pack_volume = ADC_SAR_Seq_1_GetResult16(0)*2;;
                    break;
            }
            break;
        case Mode_End:                                         // 自動運転が終了された
            auto_timer_1_StartStop = 0;                        // 自動運転用1msタイマー動作開始停止 0=停止/1動作中
            timer_1ms = 0;                                     // 1ms timer
            speed_chang_mode = 0;                              // スピード変更フラグ 0=変更なし/1=加算で変更する/2=減算で変更する
            operation_mode = Manual_DRIVE;                     // 動作モード 0=手動運転 / 1=車種選択 / 2=平坦時の速度選択 / 3=下り時の速度選択 / 4=自動運転
            forward_backward_mode_keep = 0;                    // パワーパックからの前後切り替えモード 1=前進/2=後退/3=停止
            break;
    }
    return;
}

// ******************************
//  自動運転センサーチェック処理
// ******************************
void auto_sensor_chk(void) {
    uint8 intr_pin_no = 0;

    // 手動運転なら
    if(operation_mode == Manual_DRIVE) {
        // 何もしない
        return;
    }

    // センサー1が前回と変わっていたら
    if (keep_auto_Sensor_in_1 != Sensor_in_1) {
        keep_auto_Sensor_in_1 = Sensor_in_1;
        // センサーがONになっていたら
        if (keep_auto_Sensor_in_1 == 0) {
            intr_pin_no = 1;
        }
    }
    // センサー2が前回と変わっていたら
    if (keep_auto_Sensor_in_2 != Sensor_in_2) {
        keep_auto_Sensor_in_2 = Sensor_in_2;
        // センサーがONになっていたら
        if (keep_auto_Sensor_in_2 == 0) {
            intr_pin_no = 2;
        }
    }
    // 期待しているセンサーがONになっていなければ
    if (intr_pin_no != kitai_intr_val[kitai_intr_cnt]) {
        // 何もしない
        return;
    }
    // 期待しているセンサーがONになっているなら
    else{
        // 次に期待するセンサー番号にする
        kitai_intr_cnt++;                                       // 期待している割り込みの位置用
        // 自動運転パターン 3回センサー踏んだら最初に戻る
        if (kitai_intr_cnt >= AUTO_SENSOR_PIN_MAX) {            // 期待している割り込みの位置用
            kitai_intr_cnt = 0;                                 // 期待している割り込みの位置用
        }
    }
    // センサーを踏んだ時の処理
    switch (intr_pin_no) {
        // 駅センサー
        case 1:                                                 // センサー1がONになった。
        case 2:                                                 // センサー2がONになった。
            // ゆっくり停止する
            speed_mode = Speed_Stop;                            // 停止するスピードに変更へ
            break;
    }
    return;
}

// ****************************
// タイマーを使ったスリープ処理
// 引数 停止する時間 ms
// ****************************
void auto_sleep_ms(uint16 wait_ms) {
    auto_sleeptimer_1ms = 0;
    while(1) {
        if (auto_sleeptimer_1ms >= wait_ms) {
            break;
        }
    }
}

/* [] END OF FILE */
